# -*- coding:utf-8 -*-
# Author: Perry_Zhu

import sys

import numpy as np
import pandas as pd

reload(sys)

sys.setdefaultencoding("utf-8")

from sqlalchemy import create_engine

pd.options.mode.chained_assignment = None
engine_basic = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/basic?charset=utf8', echo=True)

file_path = u"E:/现金贷/交易流水号匹配/2017-09/"
query_lkb2fund = """
SELECT id lkb_id,fund_corp,bank,transfer_time,transfer_amount ref_amount
FROM audit.lkb_to_fund 
WHERE transfer_time>='%s' AND  transfer_time<'%s'
AND id not in (
  SELECT DISTINCT lkb_id FROM  lkb_to_fund_ref
)
"""
query_ref = """
SELECT DISTINCT flow_id
FROM lkb_to_fund_ref 
WHERE created_at>='%s' 
AND  flow_id in %s
"""
start_time = '2017-09-01'
end_time = '2017-10-01'


def insert_ref():
    df_all = pd.read_excel(file_path + u'众信利民9月现金贷一般户15000033023605银行流水.xls', sheetname='Sheet1',
                           converters={'flow_id': str})
    df_all.flow_id = df_all.flow_id.astype(str)
    df_all.fund_corp = df_all.fund_corp.astype(str)
    df_all.bank = df_all.bank.astype(str)
    df_all['transfer_time'] = pd.to_datetime(df_all['transfer_time'], format='%Y%m%d').apply(lambda x: x.date())
    df_all['ref_amount'] = df_all['ref_amount'].apply(lambda x: np.round(x, 2))
    df_lkb = pd.read_sql(query_lkb2fund % (start_time, end_time), engine_basic)
    df_lkb['ref_amount'] = df_lkb['ref_amount'].apply(lambda x: np.round(x, 2))
    df_lkb['transfer_time'] = pd.to_datetime(df_lkb['transfer_time'], format='%Y%m%d').apply(lambda x: x.date())
    df_lkb.fund_corp = df_lkb.fund_corp.astype(str)
    df_lkb.bank = df_lkb.bank.astype(str)
    df_flow = pd.merge(df_all, df_lkb, on=['fund_corp', 'bank', 'transfer_time', 'ref_amount'])
    df_flow.dropna(0, inplace=True)
    if len(df_flow) > 0:
        df_flow.to_excel(file_path + u'2017-09fund2qg插入ref表的数据2.xlsx', index=None)
        df_flow.to_sql(name='lkb_to_fund_ref', con=engine_basic, if_exists='append', index=None)


insert_ref()


def insert_um_match():
    df_all = pd.read_excel(file_path + u'众信利民9月现金贷一般户15000033023605银行流水.xls', sheetname='Sheet1',
                           converters={'flow_id': str})
    df_all.flow_id = df_all.flow_id.astype(str)
    df_all['transfer_time'] = pd.to_datetime(df_all['transfer_time'], format='%Y%m%d').apply(lambda x: x.date())
    df_all['ref_amount'] = df_all['ref_amount'].apply(lambda x: np.round(x, 2))
    flowd_ids = df_all['flow_id'].tolist()
    df_ex = pd.read_sql(query_ref % (end_time, str(tuple(flowd_ids)).replace(',)', ')')), engine_basic)
    df_ex.flow_id = df_ex.flow_id.astype(str)
    df_all = df_all.ix[~df_all['flow_id'].isin(df_ex['flow_id'])]
    df_all.to_excel(file_path + u'2017-09为插入的流水数据.xlsx', index=None)
    gps = df_all.groupby(['transfer_time', 'fund_corp', 'bank'])['ref_amount'].agg(['sum']).reset_index().rename(
        columns={'sum': 'ref_amount_sum'})
    df = pd.merge(df_all, gps, on=['transfer_time', 'fund_corp', 'bank'])
    df.to_excel(file_path + u'2017-09合并后未插入的流水数据.xlsx', index=None)
    df['ref_amount_sum'] = df['ref_amount_sum'].apply(lambda x: np.round(x, 2))
    df_lkb = pd.read_sql(query_lkb2fund % (start_time, end_time), engine_basic)
    df_lkb['ref_amount'] = df_lkb['ref_amount'].apply(lambda x: np.round(x, 2))
    df_lkb['transfer_time'] = df_lkb['transfer_time'].apply(lambda x: x.date())
    df_lkb.rename(columns={'ref_amount': 'amount'}, inplace=True)
    df['ref_amount_sum'] = df['ref_amount_sum'].apply(lambda x: np.round(x, 2))
    df_lkb['amount'] = df_lkb['amount'].apply(lambda x: np.round(x, 2))
    df_lkb.to_excel(file_path + u'2017-09数据库中的数据.xlsx', index=None)
    df_flow = pd.merge(df, df_lkb, left_on=['fund_corp', 'bank', 'transfer_time', 'ref_amount_sum'],
                       right_on=['fund_corp', 'bank', 'transfer_time', 'amount'])
    df_flow.dropna(0, inplace=True)
    if len(df_flow) > 0:
        df_flow = df_flow[['fund_corp', 'bank', 'transfer_time', 'flow_id', 'ref_amount', 'lkb_id']]
        df_flow.to_excel(file_path + u'fund2qg多笔的情况插入ref表的数据2.xlsx', index=None)
        df_flow['is_mutil'] = 1
        df_flow.to_sql(name='lkb_to_fund_ref', con=engine_basic, if_exists='append', index=None)


# insert_um_match()
