# -*- encoding: utf8 -*-

"""
白条非去哪儿收入确认表
"""
from __future__ import unicode_literals
import os

import datetime
import numpy as np
import pandas as pd

from db_con.db_connect import sql_engine

pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
mysql = sql_engine('audit', 'audit').get_engine()
mysql_analysis = sql_engine('analysis', 'analysis_tmp', False).get_engine()

sql_loan = """SELECT
  fpd.product_no       产品编号,
  fc.fund_name         资金方,
  fpd.loan_amount      放款金额,
  fpd.loan_time        放款时间,
  year(fpd.loan_time)  年,
  month(fpd.loan_time) 月
FROM qunaer_new.fund_pay_detail fpd
  JOIN qunaer_new.fund_corp fc ON fc.fund_code = fpd.fund_code
                                  AND fpd.status = 1 AND fpd.loan_time >= '2017-08-01';
"""

sql_ref = """SELECT
  rd.product_no       产品编号,
  rd.repay_principle  实还本金,
  rd.repay_fee_amount 实还服务费,
  rd.repay_time       还款时间
FROM qunaer_new.repay_detail rd
WHERE rd.fund_code <> 1 AND rd.repay_time >= '2017-08-01'
"""

sql_tui = """SELECT
  product_no        产品编号,
  -refund_principle 退款本金,
  -refund_principle 退款服务费,
  refund_time       退款时间
FROM qunaer_new.refund_detail
WHERE fund_code != 1 AND refund_time >= '2017-08-01'
"""

sql_class = """
SELECT ref_id 产品编号, class 风险等级 FROM analysis_tmp.nk_bt_order_all_0930 WHERE ref_id IN {}
"""

sql_ratio = """
SELECT class 风险等级, year 年, month 月, bad_debt_ratio 计提风险金比例 FROM test_mzh.bt_service_fee_ratio
"""

df_loan_gen = pd.read_sql(sql=sql_loan, con=mysql, chunksize=10000)
res = []
for tmp in df_loan_gen:
    res.append(tmp)
df_loan = pd.concat(res)
df_repay_gen = pd.read_sql(sql=sql_ref, con=mysql, chunksize=10000)
res = []
for tmp in df_repay_gen:
    res.append(tmp)
df_repay = pd.concat(res)

df_ratio = pd.read_sql(sql=sql_ratio, con=mysql)

df_tui = pd.read_sql(sql=sql_tui, con=mysql)

# print(df_loan.groupby([df_loan['资金方'], df_loan['放款时间'].dt.month])['放款金额'].agg('sum').reset_index())
# print(df_repay.groupby(df_repay['还款时间'].dt.month)['实还服务费'].agg('sum').reset_index())

step = 5000
ref_ids = tuple(df_loan['产品编号'].astype(str).unique())
res = []
for i in xrange(0, len(ref_ids), step):
    tmp = pd.read_sql(sql=sql_class.format(str(ref_ids[i:i + step]).replace(',)', ')')), con=mysql_analysis)
    res.append(tmp)
df_class = pd.concat(res)
df_class.drop_duplicates(['产品编号'], inplace=True)
df_loan = pd.merge(df_loan, df_class, on='产品编号', how='left')
print('{}, {}'.format(len(ref_ids), df_class['产品编号'].nunique()))
print(tuple(df_loan.loc[df_loan['风险等级'].isnull(), '产品编号'].astype(str)))

df_loan = pd.merge(df_loan, df_ratio, on=['风险等级', '年', '月'])
df_loan['计提风险金'] = 0

view_dates = [datetime.date(2017, 9, 1), datetime.date(2017, 10, 1)]
file_path = 'E:/审计出表/白条/收入确认表'
res_sum = []
for v_date in view_dates:
    last_day = v_date + datetime.timedelta(days=-1)
    df_loan_v = df_loan.loc[df_loan['放款时间'] < v_date]
    df_repay_v = df_repay.loc[df_repay['还款时间'] < v_date]
    df_tui_v = df_tui.loc[df_tui['退款时间'] < v_date]

    gp_repay = df_repay_v.groupby('产品编号')['实还本金', '实还服务费'].agg('sum').reset_index()
    gp_tui = df_tui_v.groupby('产品编号')['退款本金', '退款服务费'].agg('sum').reset_index()

    df_loan_v = df_loan_v.merge(gp_repay, on='产品编号', how='left')
    df_loan_v.fillna(0, inplace=True)
    df_loan_v = df_loan_v.merge(gp_tui, on='产品编号', how='left')

    print(df_loan_v['放款金额'].sum())
    df_loan_v_1 = df_loan_v.loc[df_loan_v['退款本金'].isnull()]
    df_loan_v_2 = df_loan_v.loc[(df_loan_v['退款本金'].notnull())]
    df_loan_v_2.fillna(0, inplace=True)

    # 月末最后一天退款，修改放款金额
    last_day_product_nos = df_tui_v.loc[df_tui_v['退款时间'].dt.date == last_day, '产品编号']
    cond = np.round(df_loan_v_2['放款金额'] - df_loan_v_2['实还本金'] - df_loan_v_2['退款本金'], 2) == 0

    df_loan_v_2_last_day = df_loan_v_2.loc[df_loan_v_2['产品编号'].isin(last_day_product_nos)]
    df_loan_v_2_last_day['放款金额'] = df_loan_v_2_last_day['放款金额'] - df_loan_v_2_last_day['退款本金']
    df_loan_v_2_other = df_loan_v_2.loc[
        (~df_loan_v_2['产品编号'].isin(last_day_product_nos)) & (df_loan_v_2['实还本金'] > 0) & cond]
    df_loan_v_2 = pd.concat([df_loan_v_2_other, df_loan_v_2_last_day])

    print(df_loan_v_1['放款金额'].sum())
    print(df_loan_v_2['放款金额'].sum())
    df_loan_v = pd.concat([df_loan_v_1, df_loan_v_2])
    df_loan_v['计提风险金'] = np.round(df_loan_v['放款金额'] * df_loan_v['计提风险金比例'], 2)

    df_loan_v['assets'] = 0
    df_loan_v['收入'] = 0
    df_loan_v['减值'] = np.round(df_loan_v['计提风险金'] - df_loan_v['实还服务费'], 2)

    df_loan_v.loc[df_loan_v['放款金额'] > 0, 'assets'] = np.maximum(
        df_loan_v.loc[df_loan_v['放款金额'] > 0, '减值'], 0)
    df_loan_v.loc[df_loan_v['放款金额'] > 0, '收入'] = np.minimum(
        df_loan_v.loc[df_loan_v['放款金额'] > 0, '减值'], 0)

    df_loan_v.loc[df_loan_v['放款金额'] < 0, 'assets'] = np.minimum(
        df_loan_v.loc[df_loan_v['放款金额'] < 0, '减值'], 0)
    df_loan_v.loc[df_loan_v['放款金额'] < 0, '收入'] = np.maximum(
        df_loan_v.loc[df_loan_v['放款金额'] < 0, '减值'], 0)

    df_loan_v.drop(['减值', '退款服务费'], axis=1, inplace=True)
    df_loan_v['放款时间'] = df_loan_v['放款时间'].dt.date
    print(df_loan_v[['放款金额', '计提风险金', '实还服务费', 'assets', '收入']].sum())
    # tmp_sum = df_loan_v.groupby(u'风险等级')[
    #     [u'放款金额', u'计提风险金', u'实还服务费', u'assets', u'收入']].agg('sum').reset_index()
    tmp_sum = df_loan_v[[u'放款金额', u'计提风险金', u'实还服务费', u'assets', u'收入']].agg('sum').to_frame().T
    tmp_sum[u'截止时间'] = v_date
    res_sum.append(tmp_sum)
    df_loan_v.to_csv(os.path.join(file_path, '白条去哪儿收入确认表_{}_{:0>2}.csv'.format(v_date.year, v_date.month - 1)),
                     index=None,
                     encoding='gbk')
df_sum = pd.concat(res_sum)
df_sum.to_excel(os.path.join(file_path, '白条去哪儿汇总.xlsx'), index=None)