# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
import numpy as np
import pyexcelerate

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

step = 10000
max_limit = 900000

'''
目标 我方的资金方还款计划 VS 审计的资金方还款计划，如果出当月数据，一般使用当前库
注意 is_active = 1 的订单
使用之前需要先修改时间点，sql_query_flowid中的 t1.repaid_at，比如出9月份的表，t1.repaid_at<'2017-10-01'
'''
path = u'E:/审计出表/11月份开始使用表数据/11月份现金贷出表/'
engine_new_transaction = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/?charset=utf8',
						   echo=False).connect()


# 还资金方流水明细--1
sql_query_flowid = """
SELECT DISTINCT t1.flow_id flow_id
FROM audit.funding_repayment_record t1
  JOIN audit.loan_manifest t2 ON t1.ref_id = t2.ref_id AND t2.is_active = 1
						   AND t2.loan_paid_at >= '%s' AND t2.loan_paid_at < '%s'
						   AND t1.repaid_at < '2017-11-01' AND t1.lkb_to_fund_type = 2 AND t1.lkb2fund_id IS NOT NULL
"""

# 流水明细对应的实还资金方表
sql_query_detail = """
SELECT t1.loan_id,t2.`name` '资金方',date(t3.loan_paid_at) '放款时间',t1.term_no '期数',date(t1.repaid_at) '实还时间',t1.current_repayment '实还总额',
t1.principle '实还本金',t1.interest '实还利息',t1.flow_id '流水号'
FROM audit.funding_repayment_record t1
JOIN new_transaction.funding_corp t2 ON t1.funding_code = t2.id
JOIN audit.loan_manifest t3 ON t1.ref_id = t3.ref_id AND t3.is_active =1 AND t1.lkb_to_fund_type = 2 AND  t1.flow_id IN %s
"""

'''
流水明细对应的实还资金方表
'''
sql_flow = '''
SELECT flow_id '流水号',date(transfer_time) '转账时间',ref_amount '转账金额'
FROM basic.lkb_to_fund_ref
WHERE flow_id IN %s
'''


def flow_detail(year, month):
	#year,month = 2017,9
	start_time = datetime.date(year, month, 1)
	end_time = start_time + relativedelta(months=+1)
	df_lkb_flow_id = pd.read_sql(sql=sql_query_flowid % (start_time, end_time),
								 con=engine_new_transaction)
	df_lkb_flow_id['flow_id'].fillna(0, inplace=True)
	df_lkb_flow_id['flow_id'] = df_lkb_flow_id['flow_id'].astype(str)

	if len(df_lkb_flow_id) > 0:
		lkb_flow_ids = df_lkb_flow_id['flow_id'].tolist()
		df_flow = pd.read_sql(sql_flow % (str(tuple(lkb_flow_ids)).replace(',)', ')'),),
							  engine_new_transaction)
		df_flow.to_excel(path + u"人工控制-现金贷-流水明细(%d-%02d).xlsx" % (start_time.year, start_time.month), index=None)

		df_all_gen = pd.read_sql(sql=sql_query_detail % (str(tuple(lkb_flow_ids)).replace(',)', ')'),),
								 con=engine_new_transaction, chunksize=step)
		df_all = pd.DataFrame()
		for tmp in df_all_gen:
			df_all = df_all.append(tmp)

		all_excel = pd.ExcelWriter(path + u'人工控制-现金贷-流水明细对应的实还资金方表(%d-%02d).xlsx' % (start_time.year, start_time.month))
		for i in xrange(0, len(df_all), max_limit):
			df_all[i:i+max_limit].to_excel(all_excel, str(int(i / max_limit + 1)), index=None)
		all_excel.close()

		# all_wb = pyexcelerate.Workbook()
		# for i in xrange(0, len(df_all), max_limit):
		# 	temp = df_all[i:i+max_limit]
		# 	temp_list = temp.values.tolist()
		# 	temp_list.insert(0,temp.columns.tolist())
		# 	all_wb.new_sheet(str(int(i/max_limit + 1)),data=temp_list)
		# all_wb.save(u'流水明细对应的实还资金方表(%d-%02d).xlsx' %(start_time.year,start_time.month))

		gp = df_all.groupby([u'流水号'])[u'实还总额'].agg('sum').reset_index()

		df_diff = pd.merge(df_flow, gp, on=u'流水号', how='outer')
		df_diff.fillna(0, inplace=True)
		df_diff['diff'] = np.round(df_diff[u'转账金额'] - df_diff[u'实还总额'], 2)
		print '%d-%02d 差异：%s' % (start_time.year, start_time.month, df_diff['diff'].sum())
		df_diff.to_excel(path + u'人工控制-现金贷-流水差异(%d-%02d).xlsx' % (start_time.year, start_time.month), index=None)


import multiprocessing as mtp

def handle(year, month):
	print "start year %s month %s" % (year, month)
	# fund_to_plan(year, month)
	# ban_flow_detail(year, month)
	flow_detail(year, month)
	print "end year %s month %s" % (year, month)


if __name__ == '__main__':
	# handle(2016, 11)
	# handle(2016, 12)
	# pool = mtp.Pool(processes=6)
	for year in [2017]:
		for month in range(10,11,1):
			handle(year,month)
			# handle(year, month)
			# pool.apply_async(handle, (year, month))
	# pool.close()
	# pool.join()
	print '-----------------all main done---------------------'