# -*- coding:utf-8 -*-
# Author: WuKong

import sys
import datetime
import itertools
import pandas as pd
from sqlalchemy import create_engine
import multiprocessing as mtp
import os

start_time = "2015-01-01"
end_time = "2017-11-01"

path = u"/vpants/peifu_loan_id_bo_11/"

engine_con = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=True)

# 应还资金方本息 部分
sql_query_fund = """
SELECT deadline ,repaid_at ,principle,interest,funding_code,loan_id,term_no,ref_id FROM audit.funding_repayment_record WHERE is_active=1 ;
"""


# 部分应还资金方取客户的应还
sql_query_user_fund = """
SELECT deadline,xyqb_repaid_at repaid_at,principle,interest,fund_code funding_code,real_loan_id loan_id,term_no,ref_id FROM new_transaction.user_repayment_plan
 WHERE fund_code IN (270, 310, 320, 210, 365, 350,290, 330, 340, 390,410,420)
"""

# 客户等级
sql_query_loan_class = """
SELECT loan_id,ref_id,class,user_id FROM test_mzh.loan_class_0912;
"""

# 放款信息
sql_query_loan_manifest = """
SELECT loan_id,ref_id,funding_code,loan_paid_at,contract_loan_amount,real_loan_amount FROM audit.loan_manifest WHERE is_active in (1,-2)
"""

# 线下还款数据
sql_query_repay_offline = """
SELECT
  DATE(t3.deadline) deadline,
  DATE(t2.transfer_time) repaid_at,
  (t1.principle-t1.mitigate_principle) principle,
  (t1.interest-t1.mitigate_interest) interest,
  t3.fund_code funding_code,
  t3.real_loan_id loan_id,
  t3.term_no,
  t3.ref_id
FROM
	new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.offline_alipay_record t2 ON t1.record_id = t2.id
AND t1.repay_channel = 13
AND t2.transfer_time >= '%s'
AND t2.transfer_time < '%s'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id
"""

# 查询线上的还款
sql_query_repay_online = """
SELECT
  DATE(t3.deadline) deadline,
  DATE(t3.bill_time) repaid_at,
  (t1.principle-t1.mitigate_principle) principle,
  (t1.interest-t1.mitigate_interest) interest,
  t3.fund_code funding_code,
  t3.real_loan_id loan_id,
  t3.term_no,
  t3.ref_id
FROM
	new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id AND t1.repay_channel IN (1,2,4,6,8,9,10,11,12,20,21,25)
AND t3.bill_time >= '%s'
AND t3.bill_time < '%s'
"""

# 查询银行还款
sql_query_repay_bank = """
SELECT
  DATE(t3.deadline) deadline,
  DATE(t2.transfer_time) repaid_at,
  (t1.principle-t1.mitigate_principle) principle,
  (t1.interest-t1.mitigate_interest) interest,
  t3.fund_code funding_code,
  t3.real_loan_id loan_id,
  t3.term_no,
  t3.ref_id
FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `offline_bank_repay_record` t2 ON t1.repay_channel IN (14, 15, 16)
AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
WHERE
t2.transfer_time >= '%s'
AND t2.transfer_time < '%s'
"""

# 阳光徽商还款数据
sql_query_repay_yghuishang = """
SELECT
  DATE(deadline) deadline,
  DATE(repay_date) repaid_at,
  actual_principle principle,
  actual_interest  interest,
  340 funding_code,
  loan_id,
  term_no,
  ref_id
FROM
	new_transaction.yg_huishang_repay_term
WHERE
	repay_date >= '%s'
AND repay_date < '%s'
"""


sql_arrays = {"sql_query_fund": sql_query_user_fund
    , "sql_query_user_fund": sql_query_user_fund
    , "sql_query_loan_manifest": sql_query_loan_manifest
    , "sql_query_repay_offline": sql_query_repay_offline % (start_time, end_time)
    , "sql_query_repay_online": sql_query_repay_online % (start_time, end_time)
    , "sql_query_repay_bank": sql_query_repay_bank % (start_time, end_time)
    , "sql_query_repay_yghuishang": sql_query_repay_yghuishang % (start_time, end_time)
              }




for key in sql_arrays.iterkeys():
    file_name = key[len("sql_query_"):]
    print "handle file_name %s" % file_name
    sql_query = sql_arrays.get(key)
    df = pd.read_sql(sql=sql_query,con=engine_con)
    df.to_csv(path+file_name+".csv",columns=df.columns)
    print "save file_name %s" % file_name
