import Vue from 'vue'
import Vuex from 'vuex'
import userInfo from './modules/userInfo'
import forgetLoginInfo from './modules/forgetLoginInfo'
import withdrawDeposit from './modules/withdrawDeposit'
import loan from './modules/loan'

Vue.use(Vuex)
const store = new Vuex.Store({
  // 在严格模式下，任何 mutation 处理函数以外修改 Vuex state 都会抛出错误
  state: {},
  modules: { // 子模块
    userInfo,
    forgetLoginInfo,
    withdrawDeposit,
    loan
  },
  plugins: [],
  mutations: {
    resetVuex(state, payload) {
      for (let key in payload) {
        state[key] = payload[key];
      }
    }
  }
})

export default store
