# jstransfer

> 大麦及时雨作为一家中国第三方支付和信贷风险评估企业，针对电商卖家的服务，不仅专注于跨境收款领域，还专注于卖家的周转融资难题，依托强大的信贷风险评估技术，同合作的银行、小贷等机构一起为广大电商卖家提供专业、高效、便捷的融资服务。

## Build Setup

``` bash
# install dependencies
yarn

# serve with hot reload at localhost:8080
yarn start

# build for production with minification
yarn run build
```

For a detailed explanation on how things work, check out the [guide](http://vuejs-templates.github.io/webpack/) and [docs for vue-loader](http://vuejs.github.io/vue-loader).

## 项目结构及注意事项

``` bash
|--build
|   |----webpack.base.js(这里面可以关注一下resolve.alias,在这里定义后,可以简化require()或from后面的路径)
|   |----webpack.dev.js
|   |----webpack.prod.js
|
|--dist(构建生成的目录)
|--config
|   |--index.js(配置接口访问路径)
|--src
|   |--api
|       |--login.js(建议按模块名拆分,里面的get,post请求有一定的格式规范,具体可参考login.js)
|       |--......
|
|   |--assets(静态资源)
|
|   |--components
|       |--common(公共组件存放目录)
|       |    |--xxComponents
|       |--......
|
|   |--const(常量)
|
|   |--server
|       |--http.js(基于axios的全局api配置,有请求拦截器及响应拦截器的更细致配置,可以自行参考)
|
|   |--utils(工具类存放目录)
|   |--pages
|       |--home(官网首页)
|       |--login(登录注册)
|       |--portal(账户中心)
|       |--center(个人中心)
|       |--dailog(弹出框组件)
|       |--guide(引导页面)
|       |--payment(付款&缴税)
|       |--query(交易查询)
|       |--storeLoan(店铺贷)
|   |--router
|   |--store
|   |--app.vue
|   |--main.js(整个项目的入口)
|--index.html
|--package.json
|--README.md
|--.gitignore
|--.babelrc
|--postcss.config.js
```
