// import portalIndex from 'pages/portal/index'
const portalIndex = () => import('pages/portal/index')
//我的账户
const Account = () => import('pages/portal/account')
//缴税/付款
const Payment = () => import('pages/payment/payment')
const index = () => import('pages/payment/paymentIndex')
const vat = () => import('pages/payment/vat')
//店铺贷
const TimelyRain = () => import('pages/storeLoan/timelyRain')
const borrowMoney = () => import('pages/storeLoan/borrowMoney')
const repayment = () => import('pages/storeLoan/repayment')
const recordQuery = () => import('pages/storeLoan/recordQuery')
//申请境外收款账户
const apply = () => import('pages/portal/apply')
//更新店铺信息
const update = () => import('pages/portal/update')
const updateSucc = () => import('pages/portal/updateSucc')
//店铺详情
const all = () => import('pages/portal/all')
const detail = () => import('pages/portal/detail')
//提现
const withdrawDeposit = () => import('pages/portal/withdrawDeposit')
const withdrawDepositNext = () => import('pages/portal/withdrawDepositNext')
const withdrawSucc = () => import('pages/portal/withdrawSucc')
const withdrawFailed = () => import('pages/portal/withdrawFailed')


export default [{
  path: '/account',
  name: 'portalIndex',
  component: portalIndex,
  children: [{
      path: '/account',
      name: 'Account',
      component: Account,
      meta: {
        title: "我的账户-大麦及时雨，跨境资金一站式服务",
        requireAuth: true
      }
    },
    {
      path: '/payment/index',
      name: 'Payment',
      component: Payment,
      children: [{
        path: "/",
        name: "index",
        component: index,
        meta: {
          requireAuth: true
        }
      }, {
        path: "/payment/vat",
        name: "vat",
        component: vat,
        meta: {
          requireAuth: true
        }
      }]
    },
    {
      path: '/timelyRain',
      name: 'TimelyRain',
      component: TimelyRain,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/borrowMoney',
      name: 'borrowMoney',
      component: borrowMoney,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/repayment',
      name: 'repayment',
      component: repayment,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/recordQuery',
      name: 'recordQuery',
      component: recordQuery,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/account/apply',
      name: 'apply',
      component: apply,
      meta: {
        auth: true,
        requireAuth: true
      }
    }, {
      path: '/account/update',
      name: 'update',
      component: update,
      meta: {
        auth: true,
        requireAuth: true
      }
    }, {
      path: '/account/updateSucc',
      name: 'updateSucc',
      component: updateSucc,
      meta: {
        auth: true,
        requireAuth: true
      }
    }, {
      path: '/account/store/all',
      name: 'all',
      component: all,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/account/store/detail',
      name: 'detail',
      component: detail,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/account/withdrawDeposit',
      name: 'withdrawDeposit',
      component: withdrawDeposit,
      meta: {
        auth: true,
        requireAuth: true
      }
    }, {
      path: '/account/withdrawDeposit/next',
      name: 'withdrawDepositNext',
      component: withdrawDepositNext,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/account/withdrawDeposit/succ',
      name: 'withdrawSucc',
      component: withdrawSucc,
      meta: {
        requireAuth: true
      }
    }, {
      path: '/account/withdrawDeposit/failed',
      name: 'withdrawFailed',
      component: withdrawFailed,
      meta: {
        requireAuth: true
      }
    }
  ]
}]
