import http from 'server/http'
let host = process.env.NODE_ENV == 'development' ? '/api' : '';
//获取当前登录用户各个站点申请账户数量&实时汇率接口
export const api_findApplyCountNum = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/findApplyCountNum`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺列表接口
export const api_storeList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/storeList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//交易明细列表接口
export const api_tradeList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/tradeList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//交易列表下拉框初始化接口
export const api_showTradeInit = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/showTradeInit`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//根据平台站点查询店铺列表接口
export const api_showStoreListByCondition = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/showStoreListByCondition`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//入账详情接口
export const api_tradeDetail = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/tradeDetail`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//资金明细列表接口
export const api_fundDetailList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/fundDetailList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//资金明细列表-提现详情
export const api_fundDetail = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/fundDetail`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//申请境外收款账户接口
export const api_addStore = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/addStore`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺详情接口
export const api_findStoreDetailInfo = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/findStoreDetailInfo`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//提现列表接口
export const api_findCanWithdrawStoreList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/findCanWithdrawStoreList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//提现接口数据初始化接口
export const api_initWithdrawInfo = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/initWithdrawInfo`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//查询用户信息
export const api_findNaturalInfo = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNatural/findNaturalInfo`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺编辑保存接口
export const api_editStore = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/editStore`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//申请提现接口
export const api_applyWithdraw = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/applyWithdraw`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//文件生成记录表查询
export const api_generateFileRecordList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/generateFileRecordList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//生成交易记录、回执单、资金明细接口
export const api_generateTradeRecord = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/generateTradeRecord`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//下载交易记录接口
export const api_downloadGenerateRecord = (opt) => {
  return http({
    url: `${host}/api/v1/authc/payTrade/downloadGenerateRecord`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom,
    responseType: 'blob' //下载才用这个字段
  });
}
//编辑店铺名称接口
export const api_editStoreName = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/editStoreName`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
