import http from 'server/http'
let host = process.env.NODE_ENV == 'development' ? '/api' : '';
//店铺贷->还款
export const api_loanSituation = (opt) => {
  return http({
    url: `${host}/api/v1/anon/repayment/loanSituation`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}


//店铺贷->还款->还款操作
export const api_operation = (opt) => {
  return http({
    url: `${host}/api/v1/anon/repayment/operation`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//还款试算（店铺贷->还款->还款操作）
export const api_trial = (opt) => {
  return http({
    url: `${host}/api/v1/anon/repayment/trial`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->还款->还款详情
export const api_detailed = (opt) => {
  return http({
    url: `${host}/api/v1/anon/repayment/detailed`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款申请->填写申请资料
export const api_loan_accessm = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/access`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->授权店铺
export const api_loan_condition = (opt) => {
  return http({
    url: `${host}/api/v1/anon/storeLoan/condition`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->店铺查询
export const api_loan_appstore = (opt) => {
  return http({
    url: `${host}/api/v1/anon/storeLoan/storeList`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->输入意向借款金额
export const api_loan_application = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/application`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->借款人信息
export const api_loan_getKeyNatural = (opt) => {
  return http({
    url: `${host}/api/v1/anon/storeLoan/getKeyNatural`,
    method: 'get',
    params: opt.params,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->记录查询->借款记录
export const api_queryLoan = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/queryLoan`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->记录查询->借款记录->详情
export const api_loanDetailed = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/loanDetailed`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->记录查询->资金明细
export const api_capitalDetailed = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/capitalDetailed`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->记录查询->资金明细->详情
export const api_capitalDetailedDetails = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/capitalDetailedDetails`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->记录查询->申请记录
export const api_queryAccess = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/queryAccess`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}

//店铺贷->记录查询->申请记录->详情
export const api_queryAccessDetails = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/queryAccessDetails`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}

//还款店铺账户查询（店铺贷->还款->还款操作）
export const api_queryStoreList = (opt) => {
  return http({
    url: `${host}/api/v1/anon/repayment/queryStoreAccount`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}

//对账文件申请查询（店铺贷->记录查询->对账单下载）
export const api_applyQuery = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loanBill/applyQuery`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//对账文件申请（店铺贷->记录查询->对账单下载）
export const api_applyOperation = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loanBill/applyOperation`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}

//对账文件下载（店铺贷->记录查询->对账单下载）
export const api_download = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loanBill/download`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom,
    responseType: 'blob' //下载才用这个字段
  });
}

//合同详情查询（店铺贷->记录查询->借款记录->详情->合同）
export const api_queryContract = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/queryContract`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom,
  });
}

//店铺贷->借款申请->输入意向借款金额->银行卡信息查询
export const api_loan_query = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loanBank/query`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款申请->输入意向借款金额->绑定银行卡信息
export const api_loan_add = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loanBank/add`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->签署支用合同
export const api_loan_loanContract = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/loanContract`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款->获取图片
export const api_loan_downLoad = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsFile/downLoad`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom,
    responseType: 'blob'
  });
}
//店铺贷->借款->修改
export const api_loan_queryLoanRisk = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/queryLoanRisk`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom,
  });
}
//店铺贷->借款申请->修改提交
export const api_loan_updateLoanRisk = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/updateLoanRisk`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款申请->合同签署
export const api_loan_signContract = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/signContract`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款申请->合同归档
export const api_loan_signVerification = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/signVerification`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//店铺贷->借款申请->等待放款
export const api_loan_loanApplicationDetailed = (opt) => {
  return http({
    url: `${host}/api/v1/anon/loan/loanApplicationDetailed`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
