import http from 'server/http'
let host = process.env.NODE_ENV == 'development' ? '/api' : '';
//获取当前登录用户银行卡列表接口
export const api_bankList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/bankList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//添加银行卡页面初始化信息接口
export const api_initAddBank = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/initAddBank`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//添加银行卡接口
export const api_addBankCard = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/addBankCard`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//添加银行卡接口
export const api_disableBankCard = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/disableBankCard`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//获取地区省接口
export const api_getProvence = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/getProvence`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//获取地区省接口
export const api_getCity = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsKycBank/getCity`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//获取开户银行码值列表接口
export const api_findJsBankList = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsBank/findJsBankList`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//个人中心-提现手续费费率-接口
export const api_showWithdrawCharge = (opt) => {
  return http({
    url: `${host}/api/v1/authc/jsStore/showWithdrawCharge`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//修改密码接口
export const api_changePwd = (opt) => {
  return http({
    url: `${host}/api/v1/authc/password/changePwd`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//查询密保接口
export const api_findSecurityByKyc = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNaturalSecurity/findSecurityByKyc`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//添加/更新密保接口
export const api_saveSecurityByKyc = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNaturalSecurity/saveSecurityByKyc`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//更改手机号接口
export const api_changeMoblie = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNaturalSecurity/changeMoblie`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//修改邮箱接口
export const api_changeEmail = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNaturalSecurity/changeEmail`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//手机验证接口
export const api_sms = (opt) => {
  return http({
    url: `${host}/api/v1/anon/validateCode/sms`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//邮箱验证接口
export const api_validateEmail = (opt) => {
  return http({
    url: `${host}/api/v1/anon/validateCode/email`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
