import http from 'server/http'
// console.log(process.env.NODE_ENV);

let host = process.env.NODE_ENV == 'development' ? '/api' : '';
//校验邮箱是否存在
export const api_verifyEmailExists = (opt) => {
  return http({
    url: `${host}/api/v1/anon/register/verifyEmailExists`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//校验手机号是否存在
export const api_verifyMobileExists = (opt) => {
  return http({
    url: `${host}/api/v1/anon/register/verifyMobileExists`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//获取密码传输加密Key
export const api_getPwdKey = (opt) => {
  return http({
    url: `${host}/api/v1/anon/password/getPwdKey`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//用户注册
export const api_register = (opt) => {
  return http({
    url: `${host}/api/v1/anon/register/submit`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//发送邮箱验证码
export const api_email = (opt) => {
  return http({
    url: `${host}/api/v1/anon/code/email`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//邮箱激活
export const api_emailValidate = (opt) => {
  return http({
    url: `${host}/api/v1/authc/register/emailValidate`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//登录
export const api_login = (opt) => {
  return http({
    url: `${host}/api/v1/anon/login/pwd`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//登出
export const api_logOut = (opt) => {
  return http({
    url: `${host}/api/v1/authc/logOut`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//发送短信验证码
export const api_code = (opt) => {
  return http({
    url: `${host}/api/v1/anon/code/sms`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//获取字典表接口（店铺主要经营类别、企业性质、店铺所在站点、证件类型、证件类型）
export const api_findDictionary = (opt) => {
  return http({
    url: `${host}/api/v1/authc/dictionary/findDictionary`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//实名认证接口-大陆个人
export const api_addPersonal = (opt) => {
  return http({
    url: `${host}/api/v1/authc/certiMainLand/addPersonal`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//实名认证接口-大陆企业
export const api_addCompany = (opt) => {
  return http({
    url: `${host}/api/v1/authc/certiMainLand/addCompany`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//实名认证接口-香港个人
export const api_addHKPersonal = (opt) => {
  return http({
    url: `${host}/api/v1/authc/certiHK/addPersonal`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//实名认证接口-香港企业
export const api_addHKCompany = (opt) => {
  return http({
    url: `${host}/api/v1/authc/certiHK/addCompany`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//发送图形验证码
export const api_iamgeCode = (opt) => {
  return http({
    url: `${host}/api/v1/anon/code/image`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//图形验证码验证接口
export const api_validateImage = (opt) => {
  return http({
    url: `${host}/api/v1/anon/validateCode/image`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//设置新密码接口
export const api_changeNewPwd = (opt) => {
  return http({
    url: `${host}/api/v1/anon/password/changeNewPwd`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//修改实名认证资料接口
export const api_getCertiInfo = (opt) => {
  return http({
    url: `${host}/api/v1/authc/certi/getCertiInfo`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//汉字换拼音
export const api_convertToPinYin = (opt) => {
  return http({
    url: `${host}/api/v1/anon/jsPinYin/convertToPinYin`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//查询企业股东占股25%
export const api_getEnterprisePartners = (opt) => {
  return http({
    url: `${host}/api/v1/anon/jsPayEnterpriseInfo/getEnterprisePartners`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//kyc添加联系人接口/kycCertiContacts/getContacts
export const api_addContacts = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycCertiContacts/addContacts`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
//kyc修改联系人接口
export const api_getContacts = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycCertiContacts/getContacts`,
    method: 'get',
    params: opt.params,
    loadingDom: opt.loadingDom
  });
}
//kyc状态更改接口
export const api_updateKycNatural = (opt) => {
  return http({
    url: `${host}/api/v1/authc/kycNatural/updateKycNatural`,
    method: 'post',
    data: opt.data,
    useResWithCode: true,
    loadingDom: opt.loadingDom
  });
}
