package com.js.sync.mq;

import com.js.common.model.req.common.MailReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


@Slf4j
@Component
public class RabbitMQJsCommonSender {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Value("${spring.rabbitmq.commonExchange}")
    String exchange;
    @Value("${spring.rabbitmq.commonQueue}")
    String queue;
    @Value("${spring.rabbitmq.commonKey}")
    String key;

    public void sendMail(MailReq mailReq) {
        log.info("推送邮件信息到通用邮件发送服务");
        rabbitTemplate.convertSendAndReceive(exchange, key, mailReq);
    }

}
