package com.js.sync.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;

/**
 * jdbc 工具类
 *
 * 需要优化性能时选择性使用
 *
 * 如果需要批量功能，需要在jdbc 连接字符串上设置 rewriteBatchedStatements=true。否则效果和用 orm 框架差不多
 * 参考： https://codeleading.com/article/57308796/
 * 参考： https://www.jb51.net/article/41852.htm
 *
 */
@Component
public class JdbcUtil {

    static DataSource dataSource;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        JdbcUtil.dataSource = dataSource;
    }

    public static void execute(Consumer<Connection> consumer) {

        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            consumer.accept(conn);
            conn.commit();
        } catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            } catch (SQLException ex) {
                ex.printStackTrace();
            }
        } finally {
            if (conn != null) {
                try {
                    // 关闭时 druid 连接池会自动重置自动提交状态。
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
