package com.js.sync.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

/**
 * 流收集器，实现对 bigdecimal 的平均值计算。
 *
 * @author liutianyu
 */
public class AveragingBigDecimal implements Collector<BigDecimal, BigDecimal[], BigDecimal> {
    @Override
    public Supplier<BigDecimal[]> supplier() {
        return () -> {
            BigDecimal[] bigDecimals = new BigDecimal[2];
            bigDecimals[0] = BigDecimal.ZERO;
            bigDecimals[1] = BigDecimal.ZERO;
            return bigDecimals;
        };
    }

    @Override
    public BiConsumer<BigDecimal[], BigDecimal> accumulator() {
        return (a, b) -> {
            a[0] = a[0].add(b);
            a[1] = a[1].add(BigDecimal.ONE);
        };
    }

    @Override
    public BinaryOperator<BigDecimal[]> combiner() {
        return (a, b) -> {
            a[0] = a[0].add(b[0]);
            a[1] = a[1].add(b[1]);
            return a;
        };
    }

    @Override
    public Function<BigDecimal[], BigDecimal> finisher() {
        return (a) -> {
            if (a[1].compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            } else {
                return a[0].divide(a[1], 4, RoundingMode.HALF_UP);
            }
        };
    }

    @Override
    public Set<Characteristics> characteristics() {
        return Collections.emptySet();
    }
}
