package com.js.sync.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.amazon.mws.finances._2015_05_01.MWSFinancesServiceClient;
import com.amazon.mws.finances._2015_05_01.MWSFinancesServiceConfig;
import com.amazon.mws.finances._2015_05_01.model.ListFinancialEventGroupsRequest;
import com.amazon.mws.finances._2015_05_01.model.ListFinancialEventGroupsResponse;
import com.amazonservices.mws.client.MwsUtl;
import com.js.common.constant.Constant;
import com.js.common.enums.AmazonEndpointEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.KycStoreCheckTokenReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.sync.enums.Shop;
import com.js.api.sync.service.CheckAuthTokenService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;

import javax.xml.datatype.XMLGregorianCalendar;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class CheckAuthTokenServiceImpl implements CheckAuthTokenService {

    @Override
    public ResponseMessage checkToken(KycStoreCheckTokenReq kycStoreCheckTokenReq) {
        if (ObjectUtil.isEmpty(kycStoreCheckTokenReq.getStoreTheSite())
                || ObjectUtil.isEmpty(kycStoreCheckTokenReq.getMwsAuthToken())
                || ObjectUtil.isEmpty(kycStoreCheckTokenReq.getSellId())) {
            return ResultUtil.success(ResultEnum.CHECK_AUTH_TOKEN_FAILURE.getCode(), "参数缺少");
        }
        String serviceUrl;
        // 计算接口调用信息
        if (kycStoreCheckTokenReq.getStoreTheSite().name().equals(SiteEnum.NORTH_AMERICA_SITE.name())) {
            serviceUrl = AmazonEndpointEnum.US.getEndpoint();
        } else {
            return ResultUtil.success(ResultEnum.CHECK_AUTH_TOKEN_FAILURE.getCode(), "暂不支持该平台的校验");
        }
        MWSFinancesServiceClient client = getClient(serviceUrl);
        ListFinancialEventGroupsRequest request = new ListFinancialEventGroupsRequest();
        request.setSellerId(kycStoreCheckTokenReq.getSellId());
        request.setMWSAuthToken(kycStoreCheckTokenReq.getMwsAuthToken());

        request.setMaxResultsPerPage(1);

        XMLGregorianCalendar financialEventGroupStartedAfter = MwsUtl.getDTF().newXMLGregorianCalendar();
        ZonedDateTime utcSearch = ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).minusMonths(1);
        financialEventGroupStartedAfter.setYear(utcSearch.getYear());
        financialEventGroupStartedAfter.setMonth(utcSearch.getMonthValue());
        financialEventGroupStartedAfter.setDay(1);
        request.setFinancialEventGroupStartedAfter(financialEventGroupStartedAfter);
        log.info("token 校验，拉取一次付款账单数据，使用的时间为：{}", utcSearch);

        // 获取查询结果
        try {
            ListFinancialEventGroupsResponse response = client.listFinancialEventGroups(request);
            return ResultUtil.success(ResultEnum.CHECK_AUTH_TOKEN_SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            return ResultUtil.success(ResultEnum.CHECK_AUTH_TOKEN_FAILURE.getCode(), e.getMessage());
        }

    }

    private MWSFinancesServiceClient getClient(String serviceUrl) {
        Shop shop2 = new Shop();
        MWSFinancesServiceConfig config = new MWSFinancesServiceConfig();
        config.setServiceURL(serviceUrl);
        String applicationName = "dmjishiyupay";
        String applicationVersion = "1.0";
        return new MWSFinancesServiceClient(shop2.getAmazonAccessKey(),
                shop2.getAmazonSecrectKey(), applicationName, applicationVersion, config);
    }
}
