package com.js.sync.service.impl;

import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.JsSyncAmazonFinancialEventGroup;
import com.js.dal.dao.model.JsSyncAmazonOrder;
import com.js.dal.dao.model.JsSyncAmazonShipmentEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 亚马逊数据分析工具类
 */
@Service
public class AmazonStatisticsServiceImpl {


//    @Autowired
//    KycStoreMapper kycStoreMapper;
    @Autowired
    JsSyncAmazonOrderMapper jsSyncAmazonOrderMapper;
    @Autowired
    JsSyncAmazonFinancialEventGroupMapper jsSyncAmazonFinancialEventGroupMapper;
    @Autowired
    JsSyncAmazonShipmentEventMapper jsSyncAmazonShipmentEventMapper;
//    @Autowired
//    PlatformStatisticsByKycMapper platformStatisticsByKycMapper;
//    @Autowired
//    JsSyncAmazonInventoryMapper jsSyncAmazonInventoryMapper;

    /**
     * 查出所有相关店铺近一年的订单
     */
    public List<JsSyncAmazonOrder> getJsSyncAmazonOrders(List<String> storeIds, ZonedDateTime dateStart, ZonedDateTime dateEnd) {
        Example example = new Example(JsSyncAmazonOrder.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("storeId", storeIds);
        example.setOrderByClause("purchase_date desc");
        criteria.andLessThan("purchaseDate", Date.from(dateEnd.toInstant()));
        criteria.andGreaterThanOrEqualTo("purchaseDate", Date.from(dateStart.toInstant()));
        List<JsSyncAmazonOrder> jsSyncAmazonOrders = jsSyncAmazonOrderMapper.selectByExample(example);
        if (jsSyncAmazonOrders.size() < 2) {
            return null;
        }
        return jsSyncAmazonOrders;
    }

    /**
     * 查出所有相关店铺的付款账单(以实际到账时间计算)
     */
    public List<JsSyncAmazonFinancialEventGroup> getJsSyncAmazonFinancialEventGroups(List<String> storeIds, ZonedDateTime dateStart, ZonedDateTime dateEnd) {
        Example example = new Example(JsSyncAmazonFinancialEventGroup.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("storeId", storeIds);
        criteria.andEqualTo("originalTotalCode", "USD");
        example.setOrderByClause("fund_transfer_date desc");
        criteria.andLessThan("fundTransferDate", Date.from(dateEnd.toInstant()));
        criteria.andGreaterThanOrEqualTo("fundTransferDate", Date.from(dateStart.toInstant()));
        criteria.andEqualTo("processingStatus", "Closed");
        return jsSyncAmazonFinancialEventGroupMapper.selectByExample(example);
    }

    public List<JsSyncAmazonShipmentEvent> getJsSyncShipmentEvents(List<JsSyncAmazonFinancialEventGroup> jsSyncAmazonFinancialEventGroups) {
        List<String> financialEventIds = jsSyncAmazonFinancialEventGroups.stream()
                .map(JsSyncAmazonFinancialEventGroup::getFinancialEventGroupId)
                .collect(Collectors.toList());
        Example example = new Example(JsSyncAmazonShipmentEvent.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("financialEventGroupId", financialEventIds);
        return jsSyncAmazonShipmentEventMapper.selectByExample(example);
    }

}
