package com.js.sync.config;

import com.js.sync.pool.VisiableThreadPoolTaskExecutor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

/**
 * 异步同步数据时使用的线程池配置
 */

@Slf4j
@Configuration
@EnableAsync
public class SyncTaskPoolConfig {

    // TODO 先给这么多吧。需要观察
    private static final int corePoolSize = 50;
    private static final int maxPoolSize = 100;
    private static final int queueCapacity = 10000;

    /**
     * 主要用来在店铺第一次启用时。进行全量的数据抓取。
     */
    @Bean
    public Executor taskExecutor() {
        ThreadPoolTaskExecutor executor = new VisiableThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setThreadNamePrefix("sync-task-");
        executor.setDaemon(true);
        executor.initialize();
        return executor;
    }

    /**
     * 每天数据增量抓取时使用。
     */
    @Bean
    public Executor incrementTaskExecutor() {
        ThreadPoolTaskExecutor executor = new VisiableThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setThreadNamePrefix("sync-increment-task-");
        executor.setAllowCoreThreadTimeOut(true);
        executor.setDaemon(true);
        executor.initialize();
        return executor;
    }
}
