package com.js.api.sync.service;

import com.js.common.model.req.KycStoreCheckTokenReq;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 授权校验服务
 */
@Path("apiCheckAuthToken")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface CheckAuthTokenService {

    /**
     * 拉取一次入账账单，主要用于测试 token 是否有效，一分钟之内不可以超过30次。
     *
     * 该方法非异步调用。
     */
    @POST
    @Path("checkToken")
    ResponseMessage checkToken(@RequestBody KycStoreCheckTokenReq kycStoreCheckTokenReq);

}
