package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.concurrent.CompletableFuture;

/**
 * 亚马逊订单服务
 */
@Path("apiAmazonOrder")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonOrderService {

    /**
     * 据铺店铺 id 全量抓取数据（两年内的所有数据）
     */
    @GET
    @Path("startSyncOrderWhole/{storeId}")
    @Async("taskExecutor")
    CompletableFuture<Void> startSyncOrderWhole(@PathParam("storeId") String storeId);

    /**
     * 据铺店铺 id 增量抓取数据（两个月内的所有数据）
     */
    @GET
    @Path("startSyncOrderIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    CompletableFuture<Void> startSyncOrderIncrement(@PathParam("storeId") String storeId);

}
