package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊数据同步服务
 *
 * 主要是整合功能。
 * @author liutianyu
 */

@Path("apiAmazonSync")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonDataSyncService {

    /**
     * 铺店启用时，第一次全量同步数据(并计算店铺指标)
     */
    @GET
    @Path("startSyncStoreData/{storeId}")
    @Async("taskExecutor")
    void startSyncStoreData(@PathParam("storeId") String storeId);

    /**
     * 重算 kyc 维度的用户信息
     */
    @GET
    @Path("reCalKycStatistics/{kycNaturalId}")
    @Async("taskExecutor")
    void reCalKycStatistics(@PathParam("kycNaturalId") String kycNaturalId);

}
