package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊结算报告
 *
 * 因为结算报告只能自动生成，而且一旦生成，亚马逊只保留 90 天，所以一般只能同步近二到三个月的信息。
 * 又因为结算报告一旦生成，所指定的时间的结算报告主不会改变，所以同步时，对于重复的报告，会直接跳过而不是更新。
 *
 */
@Path("apiAmazonReport")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonSettlementReportService {

    /**
     * 同步结算报告历史
     */
    @GET
    @Path("startSyncSettlementReprotWhole/{storeId}")
    @Async("taskExecutor")
    void startSyncSettlementReportWhole(@PathParam("storeId") String storeId);

    /**
     * 结算报告（目前最新的）
     */
    @GET
    @Path("startSyncSettlementReprotIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    void startSyncSettlementReportIncrement(@PathParam("storeId") String storeId);
}
