package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊订单商品明细服务
 */
@Path("apiAmazonOrder")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonOrderItemService {

    /**
     * 据铺店铺 id 全量抓取数据（两年内的所有数据）
     */
    @GET
    @Path("startSyncOrderItemWhole/{storeId}")
    @Async("taskExecutor")
    void startSyncOrderItemWhole(@PathParam("storeId") String storeId);

    /**
     * 据铺店铺 id 增量抓取数据（两个月内的所有数据）
     */
    @GET
    @Path("startSyncOrderItemIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    void startSyncOrderItemIncrement(@PathParam("storeId") String storeId);

}
