package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊库存报告
 */
@Path("apiAmazonReport")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonInventoryReportService {

    /**
     * 同步库存报告历史
     *
     * 因为报告无法申请统计历史数据，只能通过历史的申请记录进行抓取。但是这样的话会丢失市场信息。所以取到的数据仅供参考。
     * 报告一旦生成，亚马逊保留 90 天，所以只能同步近二到三个月的信息。
     */
    @GET
    @Path("startSyncInventoryReprotWhole/{storeId}")
    @Async("taskExecutor")
    void startSyncInventoryReportWhole(@PathParam("storeId") String storeId);

    /**
     * 同步库存报告（目前最新的）
     */
    @GET
    @Path("startSyncInventoryReprotIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    void startSyncInventoryReportIncrement(@PathParam("storeId") String storeId);
}
