package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊付款事件服务
 *
 * 该服务需要在付款事件组服务执行后再执行！
 */
@Path("apiAmazonFinance")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonFinanceEventService {

    @GET
    @Path("startSyncFinanceEventWhole/{storeId}")
    @Async("taskExecutor")
    void startSyncFinanceEventWhole(@PathParam("storeId") String storeId);

    @GET
    @Path("startSyncFinanceEventIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    void startSyncFinanceEventIncrement(@PathParam("storeId") String storeId);
}
