package com.js.api.sync.service;

import org.springframework.scheduling.annotation.Async;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * 亚马逊付款事件组服务
 */
@Path("apiAmazonFinance")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface AmazonFinanceEventGroupService {

    @GET
    @Path("startSyncFinanceEventGroupWhole/{storeId}")
    @Async("taskExecutor")
    void startSyncFinanceEventGroupWhole(@PathParam("storeId") String storeId);

    @GET
    @Path("startSyncFinanceEventGroupIncrement/{storeId}")
    @Async("incrementTaskExecutor")
    void startSyncFinanceEventGroupIncrement(@PathParam("storeId") String storeId);

}
