package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description: 与寻汇用户操作相关具体实现
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiSunrateRegisterServiceImpl extends IBaseServiceImpl<KycSunrateRegister> implements ApiSunrateRegisterService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    KycCertiMainLandPersonalMapper kycCertiMainLandPersonalMapper;
    @Autowired
    KycCertiMainLandCompanyMapper kycCertiMainLandCompanyMapper;
    @Autowired
    KycCertiHKPersonalMapper kycCertiHKPersonalMapper;
    @Autowired
    KycCertiHKCompanyMapper kycCertiHKCompanyMapper;
    @Autowired
    ApiJsPayExchangeOpenAcctServiceImpl apiJsPayExchangeOpenAcctServiceimpl;

    @Override
    public ResponseMessage xhRegister(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO) {
        KycSunrateRegister kycSunrateRegister = new KycSunrateRegister();
        kycSunrateRegister.setId(IdUtil.simpleUUID());
        kycSunrateRegister.setKycCertiId(certiMainLandPersonalReq.getKycCertiId());
        kycSunrateRegister.setKycCertiType(RegisterType.MAINLAND_PERSONAL.getEnumCode());
//        kycSunrateRegister.setRegisterId(certiMainLandPersonalReq.getRegisterId());
        kycSunrateRegister.setRegisterStatus(CertiStatusEnum.NO_SUBMIT.getCode());
        kycSunrateRegister.setRegisterName(certiMainLandPersonalReq.getCusName());
        kycSunrateRegister.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegister.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegister.setRegisterType(1);
        kycSunrateRegister.setName(certiMainLandPersonalReq.getCusName());
        kycSunrateRegister.setOrgCode(certiMainLandPersonalReq.getIdNo());
        kycSunrateRegister.setIdentityType(1);// 1-法定代表人
        kycSunrateRegister.setOpenAddress(certiMainLandPersonalReq.getLiveAddress());

        String dirPath = "";
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : certiMainLandPersonalReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
            dirPath = kycCertiLinkFileReq.getUploadDirc();
        }
        kycSunrateRegister.setDirPath(dirPath);
        kycSunrateRegister.setFileIdList(fileIdList.toString());
        kycSunrateRegister.setRemark("大陆个人-注册");
        super.insertSelective(kycSunrateRegister);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage xhRegister(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        KycSunrateRegister kycSunrateRegister = new KycSunrateRegister();
        kycSunrateRegister.setId(IdUtil.simpleUUID());
        kycSunrateRegister.setKycCertiId(certiMainLandCompanyReq.getKycCertiId());
        kycSunrateRegister.setKycCertiType(RegisterType.MAINLAND_COMPANY.getEnumCode());
//        kycSunrateRegister.setRegisterId(certiMainLandCompanyReq.getRegisterId());
        kycSunrateRegister.setRegisterName(certiMainLandCompanyReq.getCompanyName());
        kycSunrateRegister.setRegisterStatus(CertiStatusEnum.NO_SUBMIT.getCode());
        kycSunrateRegister.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegister.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegister.setRegisterType(2);
        kycSunrateRegister.setName(certiMainLandCompanyReq.getCompanyName());
        kycSunrateRegister.setOrgCode(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
        kycSunrateRegister.setIdentityType(1);// 1-法定代表人
        kycSunrateRegister.setOpenAddress(certiMainLandCompanyReq.getLegalRepresentativeAddress());
        String dirPath = "";
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : certiMainLandCompanyReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
            dirPath = kycCertiLinkFileReq.getUploadDirc();
        }
        kycSunrateRegister.setDirPath(dirPath);
        kycSunrateRegister.setFileIdList(fileIdList.toString());
        kycSunrateRegister.setRemark("大陆企业-注册");
        super.insertSelective(kycSunrateRegister);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage xhRegister(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO) {
        KycSunrateRegister kycSunrateRegister = new KycSunrateRegister();
        kycSunrateRegister.setId(IdUtil.simpleUUID());
        kycSunrateRegister.setKycCertiId(kycCertiHKPersonalReq.getKycCertiId());
        kycSunrateRegister.setKycCertiType(RegisterType.HK_PERSONAL.getEnumCode());
//        kycSunrateRegister.setRegisterId(kycCertiHKPersonalReq.getRegisterId());
        kycSunrateRegister.setRegisterStatus(CertiStatusEnum.NO_SUBMIT.getCode());
        kycSunrateRegister.setRegisterName(kycNaturalVO.getCertificationName());
        kycSunrateRegister.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegister.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegister.setRegisterType(1);
        kycSunrateRegister.setName(kycCertiHKPersonalReq.getCusName());
        kycSunrateRegister.setOrgCode(kycCertiHKPersonalReq.getCertificateNo());
        kycSunrateRegister.setIdentityType(1);// 1-法定代表人
        kycSunrateRegister.setOpenAddress(kycCertiHKPersonalReq.getAddress());

        String dirPath = "";
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : kycCertiHKPersonalReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
            dirPath = kycCertiLinkFileReq.getUploadDirc();
        }
        kycSunrateRegister.setDirPath(dirPath);
        kycSunrateRegister.setFileIdList(fileIdList.toString());
        kycSunrateRegister.setRemark("香港个人-注册");
        super.insertSelective(kycSunrateRegister);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage xhRegister(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO) {
        KycSunrateRegister kycSunrateRegister = new KycSunrateRegister();
        kycSunrateRegister.setId(IdUtil.simpleUUID());
        kycSunrateRegister.setKycCertiId(kycCertiHKCompanyReq.getKycCertiId());
        kycSunrateRegister.setKycCertiType(RegisterType.HK_COMPANY.getEnumCode());
//        kycSunrateRegister.setRegisterId(kycCertiHKCompanyReq.getRegisterId());
        kycSunrateRegister.setRegisterName(kycCertiHKCompanyReq.getCompanyName());
        kycSunrateRegister.setRegisterStatus(CertiStatusEnum.NO_SUBMIT.getCode());
        kycSunrateRegister.setRegisterEmail(kycNaturalVO.getEmail());
        kycSunrateRegister.setRegisterMobile(kycNaturalVO.getPhoneNo());
        kycSunrateRegister.setRegisterType(2);
        kycSunrateRegister.setName(kycCertiHKCompanyReq.getCompanyName());
        kycSunrateRegister.setOrgCode(kycCertiHKCompanyReq.getCompanyRegisteredCertificateNo());
        kycSunrateRegister.setIdentityType(1);// 1-法定代表人
        kycSunrateRegister.setOpenAddress(kycCertiHKCompanyReq.getCompanyAddress());
        String dirPath = "";
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : kycCertiHKCompanyReq.getKycCertiLinkFileReqList()){
            fileIdList.add(kycCertiLinkFileReq.getFileSaveName());
            dirPath = kycCertiLinkFileReq.getUploadDirc();
        }
        kycSunrateRegister.setDirPath(dirPath);
        kycSunrateRegister.setFileIdList(fileIdList.toString());
        kycSunrateRegister.setRemark("香港企业-注册");
        super.insertSelective(kycSunrateRegister);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    /**
     * @Description: 寻汇注册用户接口
     */
    public ResponseMessage sendRegisterInfoToXh(String browserIP,String kycCertiId, KycSunrateRegisterReq kycSunrateRegisterReq, KycNaturalVO kycNaturalVO){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateRegisterReq));
        jsonObjectReq.put("registerType",kycSunrateRegisterReq.getRegisterType().toString());
        jsonObjectReq.put("identityType",kycSunrateRegisterReq.getIdentityType().toString());
        Map<String,String> mapParams = (Map)jsonObjectReq;
        ResponseMessage responseMessage = kycSunrateService.sendInfoToXh(browserIP,"register.create","register/create/",mapParams);
        if(!responseMessage.isSuccess()){
            responseMessage.setMsg("调用寻汇注册用户接口：" + responseMessage.getMsg());
            log.info("调用寻汇返回失败：{}",responseMessage);
            return responseMessage;
        }
        log.info("调用寻汇接口结束，插入寻汇用户表-开始");
        KycSunrateRegister kycSunrateRegister = new KycSunrateRegister();
        BeanUtils.copyProperties(kycSunrateRegisterReq,kycSunrateRegister);
        kycSunrateRegister.setId(IdUtil.simpleUUID());
        kycSunrateRegister.setKycCertiId(kycCertiId);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        kycSunrateRegister.setRegisterId(jsonObject.getString("registerId"));
        kycSunrateRegister.setRegisterStatus(CertiStatusEnum.SUBMIT_WATING.getCode());
        kycSunrateRegister.setKycNaturalId(kycNaturalVO.getId());
        kycSunrateRegister.setFileIdList(kycSunrateRegisterReq.getFileIdList().toString());
        int updateCount = iBaseMapper.insertSelective(kycSunrateRegister);
        log.info("调用寻汇接口结束，插入寻汇用户表-结束,插入条数：{}",updateCount);

        apiJsPayExchangeOpenAcctServiceimpl.jsPayExchangeOpenAcctAdd(mapParams,responseMessage);
        return responseMessage;
    }

    @Override
    public ResponseMessage queryXhAccount(String browserIP, String orgCode) {
        Map<String,String> mapParams = new HashMap<>();
        mapParams.put("orgCode",orgCode);
        return kycSunrateService.sendInfoToXh(browserIP,"register.get","register/get/",mapParams);
    }

    @Override
    public ResponseMessage registerCreateNotice(KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq) {
        log.info("开户结果通知入参：{}",JSON.toJSONString(kycSunrateRegisterNoticeReq));
        KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
        kycSunrateRegisterQuery.setRegisterId(kycSunrateRegisterNoticeReq.getRegisterId());
        KycSunrateRegister kycSunrateRegister = iBaseMapper.selectOne(kycSunrateRegisterQuery);
        if(null == kycSunrateRegister){
            log.error("寻汇开户结果通知,js方未查到此开户通知的推送信息");
            return ResultUtil.error(ResultEnum.USER_NOT_EXIST);
        }
        //当注册状态为1或者2时表示已经推送过结果
        if(1 == kycSunrateRegister.getRegisterStatus() || 2 == kycSunrateRegister.getRegisterStatus()){
            log.info("当前注册用户状态：{}",kycSunrateRegister.getRegisterStatus());
            return ResultUtil.error(ResultEnum.SEND_ALREADY);
        }
        kycSunrateRegister.setRegisterStatus(kycSunrateRegisterNoticeReq.getRegisterStatus());
        kycSunrateRegister.setRemark(kycSunrateRegisterNoticeReq.getRemark());
        iBaseMapper.updateByPrimaryKeySelective(kycSunrateRegister);

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycSunrateRegister.getKycNaturalId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.get(kycSunrateRegisterNoticeReq.getRegisterStatus()));
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }


}
