package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandPersonalService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SexEnum;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandPersonal;
import com.js.dal.dao.model.KycSunrateRegister;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;


/**
 * @Description: KycCertiMainLandPersonal具体实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiMainLandPersonalServiceImpl extends IBaseServiceImpl<KycCertiMainLandPersonal> implements ApiKycCertiMainLandPersonalService {
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    ApiSunrateRegisterServiceImpl apiSunrateRegisterServiceImpl;
    @Autowired
    ApiKycCertiLinkFilelServiceImpl apiKycCertiLinkFilelServiceImpl;

    @Override
    public ResponseMessage certiMainLandPersonalAdd(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO){
        log.info("大陆个人-实名认证提交处理开始:{}", JSON.toJSONString(certiMainLandPersonalReq));
        KycCertiMainLandPersonal kycCertiMainLandPersonal = new KycCertiMainLandPersonal();
        BeanUtils.copyProperties(certiMainLandPersonalReq,kycCertiMainLandPersonal);

        kycCertiMainLandPersonal.setId(IdUtil.simpleUUID());
        kycCertiMainLandPersonal.setIdType(certiMainLandPersonalReq.getCertiCardType().name());
        kycCertiMainLandPersonal.setIdTypeName(certiMainLandPersonalReq.getCertiCardType().getEnumName());
        kycCertiMainLandPersonal.setKycNaturalId(kycNaturalVO.getId());
        kycCertiMainLandPersonal.setCreateId(kycNaturalVO.getId());
        kycCertiMainLandPersonal.setCreateName(kycNaturalVO.getCertificationName());

        super.insertSelective(kycCertiMainLandPersonal);
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiMainLandPersonal.getId(), kycNaturalVO, certiMainLandPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆个人实名认证信息完成");

        String idNo = certiMainLandPersonalReq.getIdNo();
        String idNoSex = idNo.length() == 15 ? idNo.substring(14,15) : idNo.substring(16,17);
        Integer idNoSexNumber = Integer.parseInt(idNoSex);
        SexEnum sex = idNoSexNumber%2 != 0 ? SexEnum.MALE : SexEnum.FEMALE;
        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setSex(sex);
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_FIRST_TRIAL);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_PERSONAL);
        kycNaturalReq.setCertificationName(certiMainLandPersonalReq.getCusName());
        kycNaturalReq.setIdNo(certiMainLandPersonalReq.getIdNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiMainLandPersonal.getId());
    }

    @Override
    public boolean verifyCertiMainLandPersonExists(String idNo) {
        KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
        kycCertiMainLandPersonalQuery.setIdNo(idNo);
        KycCertiMainLandPersonal kycCertiMainLandPersonal = iBaseMapper.selectOne(kycCertiMainLandPersonalQuery);
        boolean result = null == kycCertiMainLandPersonal ? false : true;
        if(!result){
            KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
            kycSunrateRegisterQuery.setOrgCode(idNo);
            KycSunrateRegister kycSunrateRegister = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQuery);
            result = null == kycSunrateRegister ? false : true;
        }
        return result;
    }

    @Override
    public ResponseMessage certiMainLandPersonalUpdate(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆个人-实名认证编辑提交处理开始:{}", JSON.toJSONString(certiMainLandPersonalReq));
        KycCertiMainLandPersonal kycCertiMainLandPersonalSel = iBaseMapper.selectByPrimaryKey(certiMainLandPersonalReq.getId());
        if(null == kycCertiMainLandPersonalSel){
            log.error("根据主键未查询到实名认证信息：{}",certiMainLandPersonalReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(certiMainLandPersonalReq,kycCertiMainLandPersonalSel);
        kycCertiMainLandPersonalSel.setUpdateId(kycNaturalVO.getId());
        kycCertiMainLandPersonalSel.setUpdateName(kycNaturalVO.getCertificationName());
        kycCertiMainLandPersonalSel.setUpdateDts(new Date());
        int updateCertiCount = iBaseMapper.updateByPrimaryKeySelective(kycCertiMainLandPersonalSel);
        log.info("更新certimainlandperson表记录：{}条",updateCertiCount);

        KycCertiLinkFile kycCertiLinkFileDel = new KycCertiLinkFile();
        kycCertiLinkFileDel.setKycNaturalId(kycNaturalVO.getId());
        kycCertiLinkFileDel.setDelFlag(false);
        List<KycCertiLinkFile> selectList = apiKycCertiLinkFilelServiceImpl.getiBaseMapper().select(kycCertiLinkFileDel);
        selectList.stream().forEach(kycCertiLinkFile -> {
            kycCertiLinkFile.setDelFlag(true);
            kycCertiLinkFile.setUpdateDts(new Date());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(kycCertiLinkFile);
        });
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(certiMainLandPersonalReq.getId(), kycNaturalVO, certiMainLandPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆个人实名认证信息更新完成");

        String idNo = certiMainLandPersonalReq.getIdNo();
        String idNoSex = idNo.length() == 15 ? idNo.substring(14,15) : idNo.substring(16,17);
        Integer idNoSexNumber = Integer.parseInt(idNoSex);
        SexEnum sex = idNoSexNumber%2 != 0 ? SexEnum.MALE : SexEnum.FEMALE;
        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setSex(sex);
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_FIRST_TRIAL);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_PERSONAL);
        kycNaturalReq.setCertificationName(certiMainLandPersonalReq.getCusName());
        kycNaturalReq.setIdNo(certiMainLandPersonalReq.getIdNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(certiMainLandPersonalReq.getId());
    }
}
