package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySysAcctService;
import com.js.api.jspay.service.ApiJsPayTradeService;
import com.js.common.constant.Constant;
import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySysAcctReq;
import com.js.common.model.req.JsPayTradeReq;
import com.js.common.model.vo.JsPaySysAcctVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySysAcctMapper;
import com.js.dal.dao.model.JsPaySysAcct;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 平台第三方账户操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-30
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
public class ApiJsPaySysAcctServiceImpl extends IBaseServiceImpl<JsPaySysAcct> implements ApiJsPaySysAcctService {
    @Autowired
    private JsPaySysAcctMapper jsPaySysAcctMapper;
    @Autowired
    ApiJsPayTradeService apiJsPayTradeService;

    @Override
    public List<JsPaySysAcctVO> findJsPaySysAcctVOList(){
        JsPaySysAcct jsPaySysAcctQuery = new JsPaySysAcct();
        jsPaySysAcctQuery.setDelFlag(false);
        List<JsPaySysAcct> jsPaySysAccts = iBaseMapper.select(jsPaySysAcctQuery);
        List<JsPaySysAcctVO> jsPaySysAcctVOList = new ArrayList<>();
        jsPaySysAccts.stream().forEach(jsPaySysAcct -> {
            JsPaySysAcctVO jsPaySysAcctVO = new JsPaySysAcctVO();
            BeanUtils.copyProperties(jsPaySysAcct,jsPaySysAcctVO);
            jsPaySysAcctVOList.add(jsPaySysAcctVO);
        });
        return jsPaySysAcctVOList;
    }

    @Override
    public JsPaySysAcctVO queryBeneficiaryRmbList() {
        return  jsPaySysAcctMapper.queryBeneficiaryRmbList();
    }

    public List<JsPaySysAcct> findJsPaySysAcctList(JsPaySysAcctTypeEnum acctType){
        JsPaySysAcct jsPaySysAcctQuery = new JsPaySysAcct();
        jsPaySysAcctQuery.setAcctType(acctType);
        jsPaySysAcctQuery.setDelFlag(false);
        List<JsPaySysAcct> jsPaySysAccts = iBaseMapper.select(jsPaySysAcctQuery);
        return jsPaySysAccts;
    }

    @Override
    public String getJsPaySysAcctList(JsPaySysAcctReq jsPaySysAcctReq){
        PageModel pageModel = new PageModel();
        Example example = new Example(JsPaySysAcct.class);
        example.setOrderByClause("create_dts");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (null != jsPaySysAcctReq.getAcctType()) {
            criteria.andEqualTo("acctType", jsPaySysAcctReq.getAcctType());
        }
//        if (ObjectUtil.isNotEmpty(kycDictionaryReq.getName())) {
//            criteria.andLike("name", "%" + kycDictionaryReq.getName() + "%");
//        }
        PageHelper.startPage(jsPaySysAcctReq.getPageIndex(), jsPaySysAcctReq.getPageSize());
        List<JsPaySysAcct> jsPaySysAcctList = iBaseMapper.selectByExample(example);
        PageInfo<JsPaySysAcct> pageInfo = new PageInfo<>(jsPaySysAcctList);
        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(jsPaySysAcctList)) {
            List<JsPaySysAcctVO> jsPaySysAcctVOList = new ArrayList<>();
            jsPaySysAcctList.stream().forEach(JsPaySysAcct -> {
                JsPaySysAcctVO jsPaySysAcctVO = new JsPaySysAcctVO();
                BeanUtils.copyProperties(JsPaySysAcct,jsPaySysAcctVO);
                jsPaySysAcctVO.setPlateformTypeStr(JsPaySysAcct.getPlateformType().getDesc());
                jsPaySysAcctVO.setAcctTypeStr(JsPaySysAcct.getAcctType().getDesc());
                jsPaySysAcctVO.setCreateDtsStr(DateUtil.format(JsPaySysAcct.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
                jsPaySysAcctVO.setUpdateDtsStr(DateUtil.format(JsPaySysAcct.getUpdateDts(), "yyyy-MM-dd HH:mm:ss"));
                jsPaySysAcctVOList.add(jsPaySysAcctVO);
            });
            pageModel.setList(jsPaySysAcctVOList);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public ResponseMessage opeartorAcct(JsPayTradeReq jsPayTradeReq, JsPaySysAcctVO jsPaySysAcctVO) {
        if(StringUtils.isBlank(jsPaySysAcctVO.getId())){
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsPaySysAcct jsPaySysAcct = new JsPaySysAcct();
        jsPaySysAcct.setId(jsPaySysAcctVO.getId());
        jsPaySysAcct.setAvailableAmt(jsPaySysAcctVO.getAvailableAmt());
        iBaseMapper.updateByPrimaryKeySelective(jsPaySysAcct);
        apiJsPayTradeService.jsPayTradeAdd(jsPayTradeReq);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
