package com.js.pay.service.chinapnr.example.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Enumeration;

public class PfxReader {

	public static PrivateKey GetPvkformPfx(InputStream pfx, String strPassword) {
		try {
			KeyStore ks = KeyStore.getInstance("PKCS12");
			
			char[] nPassword = null;
			if ((strPassword == null) || strPassword.trim().equals("")) {
				nPassword = null;
			} else {
				nPassword = strPassword.toCharArray();
			}
			ks.load(pfx, nPassword);
			
			if(pfx != null){
				pfx.close();
			}
			// Now we loop all the aliases, we need the alias to get keys.
			// It seems that this value is the "Friendly name" field in the
			// detals tab <-- Certificate window <-- view <-- Certificate
			// Button <-- Content tab <-- Internet Options <-- Tools menu
			// In MS IE 6.
			Enumeration enumas = ks.aliases();
			String keyAlias = null;
			if (enumas.hasMoreElements())// we are readin just one certificate.
			{
				keyAlias = (String) enumas.nextElement();
			}
			// Now once we know the alias, we could get the keys.
			PrivateKey prikey = (PrivateKey) ks.getKey(keyAlias, nPassword);
			return prikey;
		} catch (Exception e) {
		}
		return null;
	}

	public static PrivateKey GetPvkformPfx(String strPfx, String strPassword) {
		try {
			return GetPvkformPfx(new FileInputStream(new File(strPfx)), strPassword);
		} catch (FileNotFoundException e) {
		}
		return null;
	}
}
