package com.js.pay.service.chinapnr.example.otherutils;

import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.*;

public class SignTool {

	/**
	 * the location where you put your private key
	 */
	private String keyFilePath;
	/**
	 * the password
	 */
	private String password = "123456";

	/**
	 * 商户号，不带01
	 */
	private String merchantAcct = "10006050001";

	/**
	 * cert alias
	 */
	private String alias = "test-alias";



	public static final String SIGNATUREPARAMS = "merchantAcctId,terminalId,version,payType,bankId,"
			+ "orderId,orderTime,orderCurrency,orderAmount,dealId,bankDealId,dealTime,"
			+ "ext1,ext2,payResult,errCode";

	public SignTool() {
	}

	public SignTool(String merchantAcct, String keyFilePath, String password,
			String alias) {
		this.merchantAcct = merchantAcct;
		this.keyFilePath = keyFilePath;
		this.password = password;
		this.alias = alias;
	}
	

	public String signMsg(String sourceMsg,String chinapnrPfxUrl) {

		System.out.println("sourceMsg:" + sourceMsg);

		String signMsg = "";
		try {
//			keyFilePath = SignTool.class.getResource(merchantAcct + ".pfx")
//					.toURI().getPath();
			//keyFilePath = ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PFX_URL") + merchantAcct + ".pfx";
			keyFilePath = chinapnrPfxUrl + merchantAcct + ".pfx";
			KeyStore ks = KeyStore.getInstance("PKCS12");
			FileInputStream ksfis = new FileInputStream(keyFilePath);
			BufferedInputStream ksbufin = new BufferedInputStream(ksfis);
			char[] keyPwd = password.toCharArray();
			ks.load(ksbufin, password.toCharArray());
			PrivateKey priK = (PrivateKey) ks.getKey(alias, keyPwd);
			Signature signature = Signature.getInstance("SHA1withRSA");
			signature.initSign(priK);
			signature.update(sourceMsg.getBytes("UTF-8"));
			sun.misc.BASE64Encoder encoder = new sun.misc.BASE64Encoder();
			signMsg = encoder.encode(signature.sign());

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		System.out.println("signMsg:" + signMsg);
		return signMsg;
	}

	public String verfiy(HttpServletRequest request,String chinapnrCer) throws IOException {
		String message = null;
		Map<String, Object> map = ServletUtils.getRequestParameters(request);
		message = message + "notify info:" + map.toString();
		System.out.println("messag===" + message);
		String dataReceived = "";
		List<String> keyList = new ArrayList<String>();
		Set<String> set = map.keySet();
		for (String key : set) {
			if (SIGNATUREPARAMS.indexOf(key) >= 0 && map.get(key) != null
					&& !StringUtils.isEmpty((String) map.get(key))) {
				keyList.add(key);
			}
		}
		Collections.sort(keyList);

		for (String key : keyList) {
			dataReceived = appendParam(dataReceived, key, (String) map.get(key));
		}

		String signMsg = (String) map.get("signMsg");
		System.err.println("signMsg===" + signMsg);

		boolean veryfyResult = false;
		try {
			//veryfyResult = XMLSecurityProcess.veryfySignature(dataReceived,signMsg);
			veryfyResult = XMLSecurityProcess.veryfySignature(URLDecoder.decode(dataReceived), URLDecoder.decode(signMsg),chinapnrCer);
		} catch (Exception e) {
			e.printStackTrace();
		}
		message = message + "\r\n " + ":" + veryfyResult;
		message += dataReceived;
		return message;
	}

	public String appendParam(String returns, String paramId, String paramValue) {
		if (returns != "") {
			if (paramValue != "") {

				returns += "&" + paramId + "=" + paramValue;
			}

		} else {

			if (paramValue != "") {
				returns = paramId + "=" + paramValue;
			}
		}

		return returns;
	}

	public static void main(String[] args) {
		SignTool pair = new SignTool();
		String sourceMsg = "bankDealId=140000046106&bankId=ICBC&dealId=1128&errCode=000000&exchangeRate=null&language=1&merchantAcctId=1002148002101&orderAmount=600&orderCurrency=EUR&orderId=20150420150332&orderTime=20150420150332&payAmount=null&payResult=10&payType=10&signType=null&version=v2.0";
		String msg = "VaDSZuu8RywzhD2ge8N4TroD2LqlUMQdG+YcD+MNdm3C6oTp1CPfrwM5GNyvHUFBXvrexfmlYd5txEfs0rB3pbDlrf9ZlwUu5UBciWUm+OZHoaomc7z8HPD+2q6JTzIH9pZ7fLBJq3s7juzSW6qtTjf6Cz6qsQvCwzwnRU05Xqs";
		//String flag = pair.signMsg(sourceMsg);
		//System.err.println("==" + flag);
		// pair.enCodeByCerA(val, msg);
	}

}
