package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiKycSecurityService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSecurityReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSecurityVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycSecurity;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;

import java.util.Date;

/**
 * @Description: 密保接口
 * @Author: liuh
 * @Create: 2019-07-8
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycSecurityServiceImpl extends IBaseServiceImpl<KycSecurity> implements ApiKycSecurityService {

    @Override
    public ResponseMessage saveSecurityByKyc(KycSecurityReq kycSecurityReq, KycNaturalVO kycNaturalVO) {
        boolean validateFlag = kycSecurityReq.getValidateFlag();
        KycSecurity kycSecurityQuery = new KycSecurity();
        kycSecurityQuery.setKycNaturalId(kycNaturalVO.getId());
        KycSecurity kycSecurity = iBaseMapper.selectOne(kycSecurityQuery);
        if(validateFlag){
            log.info("执行校验密保操作");
            if(null == kycSecurity){
                log.info("校验密保时原密保不存在");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            log.info("原始密保信息:{}",kycSecurity);
            if(StringUtils.isBlank(kycSecurityReq.getOldKycDictionaryId())){
                log.error("原字典表主键ID不能为空");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "原字典表主键ID不能为空");
            }
            if(StringUtils.isBlank(kycSecurityReq.getOldSecurityKey())){
                log.error("原密保问题不能为空");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "原密保问题不能为空");
            }
            if(StringUtils.isBlank(kycSecurityReq.getOldSecurityValue())){
                log.error("原密保问题答案不能为空");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "原密保问题答案不能为空");
            }
            if(!(kycSecurityReq.getOldKycDictionaryId().equals(kycSecurity.getKycDictionaryId())
                    && kycSecurityReq.getOldSecurityKey().equals(kycSecurity.getSecurityKey())
                    && kycSecurityReq.getOldSecurityValue().equals(kycSecurity.getSecurityValue()))){
                return ResultUtil.error(ResultEnum.QUESTION_ANSWER_NOT_EQUALS);
            }
        }else{
            if(StringUtils.isBlank(kycSecurityReq.getKycDictionaryId())
                    || StringUtils.isBlank(kycSecurityReq.getSecurityKey())
                    || StringUtils.isBlank(kycSecurityReq.getSecurityValue())){
                log.error("新增或修改时必填项不能为空");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            if(null == kycSecurity){
                log.info("执行新增密保操作");
                kycSecurity = new KycSecurity();
                BeanUtils.copyProperties(kycSecurityReq,kycSecurity);
                kycSecurity.setId(IdUtil.simpleUUID());
                kycSecurity.setKycNaturalId(kycNaturalVO.getId());
                kycSecurity.setCreateId(kycNaturalVO.getId());
                kycSecurity.setCreateName(kycNaturalVO.getCertificationName());
                kycSecurity.setCreateDts(new Date());
                int insertCount = iBaseMapper.insertSelective(kycSecurity);
                log.info("插入密保条数：{}",insertCount);
            }else{
                log.info("执行更新密保操作");
                if(kycSecurityReq.getKycDictionaryId().equals(kycSecurity.getKycDictionaryId())
                        || kycSecurityReq.getSecurityKey().equals(kycSecurity.getSecurityKey())){
                    return ResultUtil.error(ResultEnum.QUESTION_NEW_EQUELS_OLD);
                }
                kycSecurity.setKycDictionaryId(kycSecurityReq.getKycDictionaryId());
                kycSecurity.setSecurityKey(kycSecurityReq.getSecurityKey());
                kycSecurity.setSecurityValue(kycSecurityReq.getSecurityValue());
                int updateCount = iBaseMapper.updateByPrimaryKeySelective(kycSecurity);
                log.info("更新密保条数：{}",updateCount);
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage findSecurityByKyc(KycNaturalVO kycNaturalVO) {
        KycSecurity kycSecurityQuery = new KycSecurity();
        kycSecurityQuery.setKycNaturalId(kycNaturalVO.getId());
        KycSecurity kycSecurity = iBaseMapper.selectOne(kycSecurityQuery);
        if(null != kycSecurity){
            KycSecurityVO kycSecurityVO = new KycSecurityVO();
            kycSecurityVO.setKycDictionaryId(kycSecurity.getKycDictionaryId());
            kycSecurityVO.setSecurityKey(kycSecurity.getSecurityKey());
            return ResultUtil.success(kycSecurityVO);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
