package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiKycHolderCompanyService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycHolderCompanyReq;
import com.js.common.model.vo.KycHolderVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycCertiLinkFileMapper;
import com.js.dal.dao.mapper.KycHolderCompanyMapper;
import com.js.dal.dao.model.KycHolderCompany;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:持有人（大陆企业，香港企业）操作服务接口
 * @Author: liuh
 * @Create: 2019-05-23
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycHolderCompanyServiceImpl extends IBaseServiceImpl<KycHolderCompany> implements ApiKycHolderCompanyService {
    @Autowired
    KycHolderCompanyMapper kycHolderCompanyMapper;
    @Autowired
    KycCertiLinkFileMapper kycCertiLinkFileMapper;
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;

    @Override
    public List<KycHolderVO> holderCompanyList(String holderName,KycNaturalVO kycNaturalVO) {
        log.info("持有人-企业列表查询开始 -> 当前登录用户ID：{}",kycNaturalVO.getId());
        KycHolderCompany kycHolderCompanyQuery = new KycHolderCompany();
        kycHolderCompanyQuery.setCreateId(kycNaturalVO.getId());
        if(StringUtils.isNotBlank(holderName)){
            kycHolderCompanyQuery.setCompanyName(holderName);
        }
        List<KycHolderCompany> kycHolderCompanyList = kycHolderCompanyMapper.select(kycHolderCompanyQuery);
        List<KycHolderVO> kycHolderVOList = new ArrayList<>();
        for(KycHolderCompany kycHolderCompany : kycHolderCompanyList){
            kycHolderVOList.add(ConvertToKycHolderVO(kycHolderCompany));
        }
        log.info("持有人-企业列表查询结束");
        return kycHolderVOList;
    }

    @Override
    public ResponseMessage holderCompanyAdd(KycHolderCompanyReq kycHolderCompanyReq, KycNaturalVO kycNaturalVO) {
        KycHolderCompany kycHolderCompany = new KycHolderCompany();
        BeanUtils.copyProperties(kycHolderCompanyReq,kycHolderCompany);
        kycHolderCompany.setId(IdUtil.simpleUUID());
        kycHolderCompany.setKycNaturalId(kycNaturalVO.getId());
        kycHolderCompany.setCreateId(kycNaturalVO.getId());
        kycHolderCompany.setCreateName(kycNaturalVO.getCertificationName());

//        kycCertiLinkFileMapper.insertList(kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycHolderCompany.getId(),kycNaturalVO,kycHolderCompanyReq.getFileReqList()));
        kycHolderCompanyMapper.insertSelective(kycHolderCompany);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    private KycHolderVO ConvertToKycHolderVO(KycHolderCompany kycHolderCompany) {
        KycHolderVO kycHolderVO = new KycHolderVO();
        kycHolderVO.setHolderId(kycHolderCompany.getId());
        kycHolderVO.setHolderName(kycHolderCompany.getCompanyName());
        kycHolderVO.setHolderType(kycHolderCompany.getHolderType());
        return kycHolderVO;
    }
}
