package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsPaySupplierBatDtlService;
import com.js.api.jspay.service.ApiJsPaySupplierBatService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySupplierInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySupplierBatDtlMapper;
import com.js.dal.dao.model.JsPaySupplierBat;
import com.js.dal.dao.model.JsPaySupplierBatDtl;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySupplierBatDtlServiceImpl extends IBaseServiceImpl<JsPaySupplierBatDtl> implements ApiJsPaySupplierBatDtlService {

    @Autowired
    private JsPaySupplierBatDtlMapper jsPaySupplierBatDtlMapper;


    @Override
    public ResponseMessage insertPaySupplierDtl(JsPaySupplierInfoReq jsPaySupplierInfoReq) {
        JsPaySupplierBatDtl jsPaySupplierBatDtl = new JsPaySupplierBatDtl();
        BeanUtils.copyProperties(jsPaySupplierInfoReq,jsPaySupplierBatDtl);
        iBaseMapper.insertSelective(jsPaySupplierBatDtl);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
