package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiWaiHuiService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.WaiHuiVO;
import com.js.common.util.ExchangeUtils;
import com.js.common.util.RedisUtil;
import com.js.dal.dao.model.AliWaihui;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
public class ApiWaiHuiServiceImpl extends IBaseServiceImpl<AliWaihui> implements ApiWaiHuiService {

    @Autowired
    RedisUtil redisUtil;

    @Override
    public WaiHuiVO getWaiHuiInfo(String currency) {
        if(StringUtils.isBlank(currency)){
            return null;
        }
        String waiHuiJson = redisUtil.get(Constant.REDIS_JS_WEB_USER_WAIHUI + currency);
        if(StringUtils.isNotBlank(waiHuiJson)){
            log.info("redis获取汇率:{}",waiHuiJson);
            return JSON.toJavaObject(JSON.parseObject(waiHuiJson),WaiHuiVO.class);
        }
        Map<String, WaiHuiVO> waiHuiVOMap = ExchangeUtils.getValue("");
        log.info("接口获取汇率 :{}" ,waiHuiVOMap.get(currency));
        Thread thread = new Thread(() -> {
            exeSaveToRedis(waiHuiVOMap);
        });
        thread.start();
        return waiHuiVOMap.get(currency);
    }

    private void exeSaveToRedis(Map<String, WaiHuiVO> waiHuiVOMap){
        waiHuiVOMap.forEach((key,waiHuiVO) -> {
            redisUtil.setex(Constant.REDIS_JS_WEB_USER_WAIHUI + key, 5 * 60, JSON.toJSONString(waiHuiVO));
        });
    }

    @Override
    public int saveWaiHuiInfo(WaiHuiVO waiHuiVO, KycNaturalVO kycNaturalVO) {
        int saveCount = 0;
        try {
            AliWaihui aliWaihui = new AliWaihui();
            BeanUtils.copyProperties(waiHuiVO,aliWaihui);
            aliWaihui.setId(IdUtil.simpleUUID());
            aliWaihui.setCreateId(kycNaturalVO.getId());
            aliWaihui.setCreateName(kycNaturalVO.getCertificationName());
            aliWaihui.setCreateDts(new Date());
            return iBaseMapper.insertSelective(aliWaihui);
        }catch (Exception ex){
            log.error("插入查询汇率信息失败:",ex);
        }
        return saveCount;
    }
}
