package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiJsPayVatPaymentInfoService;
import com.js.api.jspay.service.ApiKycSunrateStoreService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.JsPaySunrateBankReq;
import com.js.common.model.req.JsPaySunrateTradeMarketOrderReq;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPayVatPaymentInfoMapper;
import com.js.dal.dao.model.JsPayVatPaymentInfo;
import com.js.dal.dao.model.KycNatural;
import com.js.dal.dao.model.KycStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;
import java.util.Random;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayVatPaymentInfoServiceImpl extends IBaseServiceImpl<JsPayVatPaymentInfo> implements ApiJsPayVatPaymentInfoService {
    @Autowired
    JsPayVatPaymentInfoMapper jsPayVatPaymentInfoMapper;

//    @Autowired
//    private ApiJsPayVatPaymentInfoService apiJsPayVatPaymentInfoService;
    @Autowired
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Autowired
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Autowired
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;

    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;

    @Override
    public ResponseMessage queryRcvList(String kycNaturalId) {
        log.info("查询已添加的缴税局列表:{} start",kycNaturalId);
        List<JsPayStationOrganInfoVO> vatPaymentList = jsPayVatPaymentInfoMapper.queryRcvList(kycNaturalId);
        vatPaymentList.stream().forEach(jsPayStationOrganInfoVO -> {
            jsPayStationOrganInfoVO.setTaxStationCountryDesc(CountryCodeEnum.valueOf(jsPayStationOrganInfoVO.getTaxStationCountry()).getEnumName());
        });
        PageInfo<JsPayStationOrganInfoVO> pageInfo = new PageInfo<>(vatPaymentList);
        log.info("查询已添加的缴税局列表:{} end");
        return ResultUtil.success(pageInfo);
    }

    @Override
    public ResponseMessage queryVatList(String str) {
        List<JsPayVatPaymentInfoVO> list = jsPayVatPaymentInfoMapper.queryVatList("");
        return ResultUtil.success(list);
    }

    /**
     * 根据受益人ID查询JsPayVatPaymentInfoReq 集合信息
     * @param beneficiaryId
     * @return
     */
    @Override
    public ResponseMessage queryJsPayVatPaymentInfoReqList(String beneficiaryId) {
        log.info("查询受益人的JsPayVatPaymentInfoReq 列表:{} start",beneficiaryId);
        List<JsPayVatPaymentInfoReq> vatPaymentList = jsPayVatPaymentInfoMapper.queryJsPayVatPaymentInfos(beneficiaryId);
        log.info("查询受益人的JsPayVatPaymentInfoReq 列表end");
        return ResultUtil.success(vatPaymentList);
    }

    @Override
    public ResponseMessage addPayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq) {
        JsPayVatPaymentInfo jsPayVatPaymentInfo = new JsPayVatPaymentInfo();
        BeanUtils.copyProperties(jsPayVatPaymentInfoReq,jsPayVatPaymentInfo);
//        jsPayVatPaymentInfo.setId(jsPayVatPaymentInfoReq.getId());
        insertSelective(jsPayVatPaymentInfo);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }


    @Override
    public ResponseMessage beneficiayAuditNotice(String beneficiayId) {
        JsPayVatPaymentInfo jsPayVatPaymentInfo = new JsPayVatPaymentInfo();
        jsPayVatPaymentInfoMapper.queryJsPayVatPaymentInfos(beneficiayId);
//        BeanUtils.copyProperties(jsPayVatPaymentInfoReq,jsPayVatPaymentInfo);
////        jsPayVatPaymentInfo.setId(jsPayVatPaymentInfoReq.getId());
//        iBaseMapper.insertSelective(jsPayVatPaymentInfo);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage updatePayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq,String id){
        log.info("更新Vat缴税信息开始：{}", JSON.toJSONString(jsPayVatPaymentInfoReq));
        try{
            JsPayVatPaymentInfo jsPayVatPaymentInfo = new JsPayVatPaymentInfo();
            Example example = new Example(JsPayVatPaymentInfo.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("id", id);
            jsPayVatPaymentInfo.setTxnNo(jsPayVatPaymentInfoReq.getTxnNo());
            jsPayVatPaymentInfo.setLockNo(jsPayVatPaymentInfoReq.getLockNo());
            jsPayVatPaymentInfo.setFeeAmt(jsPayVatPaymentInfoReq.getFeeAmt());
            jsPayVatPaymentInfo.setFeeCur(jsPayVatPaymentInfoReq.getFeeCur());
            jsPayVatPaymentInfo.setFinRate(jsPayVatPaymentInfoReq.getFinRate());
            jsPayVatPaymentInfo.setPayAmt(jsPayVatPaymentInfoReq.getPayAmt());
            jsPayVatPaymentInfo.setStatus(jsPayVatPaymentInfoReq.getStatus());
            updateByExampleSelective(jsPayVatPaymentInfo, example);
            log.info("更新Vat缴税信息结束:{}");
        }catch (Exception e){
            return ResultUtil.error(ResultEnum.UPDATE_ERROR);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage updateStatusById( List<String> ids,String status) {
        JsPayVatPaymentInfo jsPayVatPaymentInfo = new JsPayVatPaymentInfo();
        try {
            Example example = new Example(JsPayVatPaymentInfo.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("id", ids);
            jsPayVatPaymentInfo.setStatus(status);
            updateByExampleSelective(jsPayVatPaymentInfo, example);
        }catch (Exception e){
            e.printStackTrace();
            log.error(e.getMessage());
            return ResultUtil.error(ResultEnum.UPDATE_ERROR );
        }
        return  ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
    }

    public ResponseMessage beneficiayAuditNoticeVatPayTrade(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO){
        log.info("vat缴税信息入DB start:");
            jsPayVatPaymentInfoReq.setStatus(CommonConstant.XH_TRADE_CONFIRM);
            ResponseMessage responseMessage = tradeMarketOrder(jsPayVatPaymentInfoReq,kycNaturalVO);
            if(responseMessage.isSuccess()){
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
                jsPayVatPaymentInfoReq.setTxnNo(jsonObject.getString("txnNo"));
                jsPayVatPaymentInfoReq.setLockNo(jsonObject.getString("lockNo"));
                jsPayVatPaymentInfoReq.setFeeAmt(jsonObject.getBigDecimal("feeAmt"));
                jsPayVatPaymentInfoReq.setFeeCur(jsonObject.getString("feeCur"));
                jsPayVatPaymentInfoReq.setFinRate(jsonObject.getBigDecimal("finRate"));
                jsPayVatPaymentInfoReq.setPayAmt(jsonObject.getBigDecimal("payAmt"));
                jsPayVatPaymentInfoReq.setStatus(jsonObject.getString("txnStatus"));
            }else{
                return responseMessage;
            }

        return ResultUtil.success(jsPayVatPaymentInfoReq);
    }

    /**
     *  vat缴税记录到DB
     * @param jsPayVatPaymentInfoReq
     * @return
     */
    public ResponseMessage addVatPayTrade(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO){
        log.info("vat缴税信息入DB start:");
        List<JsPayVatSubAcctInfoVO> subAcctNoList = jsPayVatPaymentInfoReq.getSubAcctNoInfoList();
        for(JsPayVatSubAcctInfoVO subAcctNoVO : subAcctNoList){
            jsPayVatPaymentInfoReq.setStoreId(subAcctNoVO.getStoreId());
            jsPayVatPaymentInfoReq.setSubAcctNo(subAcctNoVO.getSubAcctNo());
            jsPayVatPaymentInfoReq.setPayAmt(subAcctNoVO.getPayAmt());
            jsPayVatPaymentInfoReq.setPayCur(subAcctNoVO.getPayCur());
            jsPayVatPaymentInfoReq.setStatus(CommonConstant.XH_TRADE_CONFIRM);
            jsPayVatPaymentInfoReq.setId(IdUtil.simpleUUID());

            addPayVatPaymentInfo(jsPayVatPaymentInfoReq);

            ResponseMessage responseMessage = tradeMarketOrder(jsPayVatPaymentInfoReq,kycNaturalVO);
            if(responseMessage.isSuccess()){
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
                jsPayVatPaymentInfoReq.setTxnNo(jsonObject.getString("txnNo"));
                jsPayVatPaymentInfoReq.setLockNo(jsonObject.getString("lockNo"));
                jsPayVatPaymentInfoReq.setFeeAmt(jsonObject.getBigDecimal("feeAmt"));
                jsPayVatPaymentInfoReq.setFeeCur(jsonObject.getString("feeCur"));
                jsPayVatPaymentInfoReq.setFinRate(jsonObject.getBigDecimal("finRate"));
                jsPayVatPaymentInfoReq.setPayAmt(jsonObject.getBigDecimal("payAmt"));
                jsPayVatPaymentInfoReq.setStatus(jsonObject.getString("txnStatus"));
            }else{
                return responseMessage;
            }
        }
        return ResultUtil.success(jsPayVatPaymentInfoReq);
    }

    private ResponseMessage tradeMarketOrder(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO){
        String kycNaturalId = jsPayVatPaymentInfoReq.getKycNaturalId();
        KycSunrateStoreVO kycSunrateStoreVO = apiKycSunrateStoreService.findSunrateStoreInfo(jsPayVatPaymentInfoReq.getStoreId(),"",kycNaturalId);
        String kycSunrateStoreId = kycSunrateStoreVO.getId();
        jsPayVatPaymentInfoReq.setKycSunrateStoreId(kycSunrateStoreId);
        jsPayVatPaymentInfoReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankReq jsPaySunrateBankReq = new JsPaySunrateBankReq();
        jsPaySunrateBankReq.setOrgCode(jsPayVatPaymentInfoReq.getOrgCode());
        jsPaySunrateBankReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankVO jsPaySunrateBankVO = apiJsPaySunrateBankService.findSunrateBankInfo(jsPaySunrateBankReq,kycNaturalVO);
        String kycSunrateBankId = jsPaySunrateBankVO.getId();
        jsPayVatPaymentInfoReq.setKycSunrateBankId(kycSunrateBankId);
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = ConvertToJsPaySunrateTradeMarketOrderReq(jsPayVatPaymentInfoReq);
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPayVatPaymentInfoReq.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        return apiJsPaySunrateTradeLockPriceService.tradeMarketOrder( jsPaySunrateTradeMarketOrderReq, kycNaturalId, kycSunrateStoreId, kycSunrateBankId);
    }

    private JsPaySunrateTradeMarketOrderReq ConvertToJsPaySunrateTradeMarketOrderReq(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();
        jsPayVatPaymentInfoReq.setLockNo(jsPaySunrateTradeMarketOrderReq.getLockNo());
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPayVatPaymentInfoReq.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(jsPayVatPaymentInfoReq.getSubAcctNo());
        jsPaySunrateTradeMarketOrderReq.setBuyCur(jsPayVatPaymentInfoReq.getPayCur());
        jsPaySunrateTradeMarketOrderReq.setSellCur(jsPayVatPaymentInfoReq.getPayCur());
        jsPaySunrateTradeMarketOrderReq.setTxnAmt(jsPayVatPaymentInfoReq.getPayAmt());
        jsPaySunrateTradeMarketOrderReq.setValueDate(DateUtil.format(new Date(),"yyyy-MM-dd"));
        jsPaySunrateTradeMarketOrderReq.setTradeType(TradeTypeEnum.TRADE_PAYMENT);
        jsPaySunrateTradeMarketOrderReq.setTradeSubType(TradeSubTypeEnum.VAT_PAYMENT);
        jsPaySunrateTradeMarketOrderReq.setBeneficiaryId(jsPayVatPaymentInfoReq.getBeneficiaryId());//受益人编号
        jsPaySunrateTradeMarketOrderReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
        return jsPaySunrateTradeMarketOrderReq;
    }

    private String getReqNo() {
        String result = DateUtil.format(new Date(), "yyyyMMddHHmmssSSS");
        Random rand = new Random();
        int n = 3;
        for (int i = 0; i < n; i++) {
            int randInt = rand.nextInt(10);
            result += randInt;
        }
        return result;
    }
}
