package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiJsPaySupplierInfoService;
import com.js.api.jspay.service.ApiKycSunrateStoreService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import com.js.common.model.req.JsPaySunrateBankReq;
import com.js.common.model.req.JsPaySunrateTradeMarketOrderReq;
import com.js.common.model.req.JsPaySupplierInfoReq;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.vo.JsPaySunrateBankVO;
import com.js.common.model.vo.JsPayVatSubAcctInfoVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySupplierInfoMapper;
import com.js.dal.dao.model.JsPaySupplierInfo;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Date;
import java.util.List;
import java.util.Random;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySupplierInfoServiceImpl extends IBaseServiceImpl<JsPaySupplierInfo> implements ApiJsPaySupplierInfoService {

    @Autowired
    JsPaySupplierInfoMapper jsPaySupplierInfoMapper;

    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Autowired
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Autowired
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;





    @Override
    public String queryBeneficiary(JsPaySupplierInfoReq jsPaySupplierInfoReq) {
        return jsPaySupplierInfoMapper.queryBeneficiary(jsPaySupplierInfoReq);
    }

    @Override
    public String querySupplierInfoStatus(String beneficiaryId) {

        return null;
    }

    @Override
    public ResponseMessage insertPaySupplierInfo(JsPaySupplierInfoReq jsPaySupplierInfoReq) {
        JsPaySupplierInfo jsPaySupplierInfo = new JsPaySupplierInfo();
        BeanUtils.copyProperties(jsPaySupplierInfoReq,jsPaySupplierInfo);
        jsPaySupplierInfoMapper.insertSelective(jsPaySupplierInfo);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage addSupplierPayTrade(JsPaySupplierInfoReq jsPaySupplierInfoReq, KycNaturalVO kycNaturalVO){
        ResponseMessage responseMessage = tradeMarketOrder(jsPaySupplierInfoReq,kycNaturalVO);
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            jsPaySupplierInfoReq.setTxnNo(jsonObject.getString("txnNo"));
            jsPaySupplierInfoReq.setLockNo(jsonObject.getString("lockNo"));
            jsPaySupplierInfoReq.setFeeAmt(jsonObject.getBigDecimal("feeAmt"));
            jsPaySupplierInfoReq.setFeeCur(jsonObject.getString("feeCur"));
            jsPaySupplierInfoReq.setFinRate(jsonObject.getBigDecimal("finRate"));
            jsPaySupplierInfoReq.setPayAmt(jsonObject.getBigDecimal("payAmt"));
            jsPaySupplierInfoReq.setStatus(jsonObject.getString("txnStatus"));
        }else{
            return responseMessage;
        }
        return ResultUtil.success(jsPaySupplierInfoReq,ResultEnum.SUCCESS);
    }


    private ResponseMessage tradeMarketOrder(JsPaySupplierInfoReq jsPaySupplierInfoReq, KycNaturalVO kycNaturalVO){
        String kycNaturalId = jsPaySupplierInfoReq.getKycNaturalId();
        KycSunrateStoreVO kycSunrateStoreVO = apiKycSunrateStoreService.findSunrateStoreInfo(jsPaySupplierInfoReq.getStoreId(),"",kycNaturalId);
        String kycSunrateStoreId = kycSunrateStoreVO.getId();
        jsPaySupplierInfoReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankReq jsPaySunrateBankReq = new JsPaySunrateBankReq();
        jsPaySunrateBankReq.setOrgCode(jsPaySupplierInfoReq.getOrgCode());
        jsPaySunrateBankReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankVO jsPaySunrateBankVO = apiJsPaySunrateBankService.findSunrateBankInfo(jsPaySunrateBankReq,kycNaturalVO);
        String kycSunrateBankId = jsPaySunrateBankVO.getId();
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = ConvertToJsPaySunrateTradeMarketOrderReq(jsPaySupplierInfoReq);
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPaySupplierInfoReq.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        return apiJsPaySunrateTradeLockPriceService.tradeMarketOrder( jsPaySunrateTradeMarketOrderReq, kycNaturalId, kycSunrateStoreId, kycSunrateBankId);
    }

    private JsPaySunrateTradeMarketOrderReq ConvertToJsPaySunrateTradeMarketOrderReq(JsPaySupplierInfoReq jsPaySupplierInfoReq){
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPaySupplierInfoReq.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(jsPaySupplierInfoReq.getSubAcctNo());
        jsPaySunrateTradeMarketOrderReq.setBuyCur(jsPaySupplierInfoReq.getTradeCur());
        jsPaySunrateTradeMarketOrderReq.setSellCur(jsPaySupplierInfoReq.getTradeCur());
        jsPaySunrateTradeMarketOrderReq.setTxnAmt(jsPaySupplierInfoReq.getTradeAmt());
        jsPaySunrateTradeMarketOrderReq.setValueDate(DateUtil.format(new Date(),"yyyy-MM-dd"));
        jsPaySunrateTradeMarketOrderReq.setTradeType(TradeTypeEnum.TRADE_PAYMENT);
        jsPaySunrateTradeMarketOrderReq.setTradeSubType(TradeSubTypeEnum.VAT_PAYMENT);
        jsPaySunrateTradeMarketOrderReq.setBeneficiaryId(jsPaySupplierInfoReq.getBeneficiaryId());//受益人编号
        jsPaySunrateTradeMarketOrderReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
        return jsPaySunrateTradeMarketOrderReq;
    }

    private String getReqNo() {
        String result = DateUtil.format(new Date(), "yyyyMMddHHmmssSSS");
        Random rand = new Random();
        int n = 3;
        for (int i = 0; i < n; i++) {
            int randInt = rand.nextInt(10);
            result += randInt;
        }
        return result;
    }
}
