package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsCommFileResourceService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsCommFileResourceReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsCommFileResource;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.apache.dubbo.config.annotation.Service;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Author yjzhao
 * @Description 文件操作
 * @Date 2019/5/22 18:33
 * @Param 
 * @return 
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsCommFileResourceServiceImpl extends IBaseServiceImpl<JsCommFileResource> implements ApiJsCommFileResourceService {


    @Override
    public ResponseMessage saveJsCommFileResource(JsCommFileResourceReq jsCommFileResourcereq){

        JsCommFileResource jsCommFileResource = convertToJsCommFileResource(jsCommFileResourcereq);
        this.insertSelective(jsCommFileResource);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }


    private JsCommFileResource convertToJsCommFileResource(JsCommFileResourceReq jsCommFileResourcereq) {
        JsCommFileResource jsCommFileResource = new JsCommFileResource();
        jsCommFileResource.setId(jsCommFileResourcereq.getId());
        jsCommFileResource.setFileExt(jsCommFileResourcereq.getFileExt());
        jsCommFileResource.setFileResourceType(jsCommFileResourcereq.getFileResourceType().getEnumCode());
        jsCommFileResource.setFileSaveName(jsCommFileResourcereq.getFileSaveName());
        jsCommFileResource.setFileSavePath(jsCommFileResourcereq.getFileSavePath());
        jsCommFileResource.setFileShowName(jsCommFileResourcereq.getFileShowName());
        jsCommFileResource.setFileShowPath(jsCommFileResourcereq.getFileShowPath());
        jsCommFileResource.setFileSize(jsCommFileResourcereq.getFileSize());
        jsCommFileResource.setFileThumbnailPath(jsCommFileResourcereq.getFileThumbnailPath());
        jsCommFileResource.setFileType(jsCommFileResourcereq.getFileType().getEnumCode());
        return jsCommFileResource;
    }


}
