package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiIMailService;
import com.js.api.jspay.service.ApiKycDictionaryService;
import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.dal.dao.model.KycDictionary;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description: 邮箱服务实现
 * @Author: liuh
 * @Create: 2019-07-14
 **/
@Service
@Slf4j
public class ApiIMailServiceImpl implements ApiIMailService {
    @Autowired
    private JavaMailSender mailSender;
    @Value("${spring.mail.from}")
    private String from;
    @Autowired
    private ApiKycDictionaryService apiKycDictionaryService;

    /**
     * 发送文本邮件
     * @param to
     * @param subject
     * @param content
     */
    @Override
    public void sendSimpleMail(String to, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setText(content);
        mailSender.send(message);
    }

    @Override
    public void sendRemindEmail(String subject,String content, EmailRemindTypeEnum emailRemindTypeEnum) {
        ResponseMessage responseMessage = apiKycDictionaryService.findDictionary(emailRemindTypeEnum.getType(), "");
        if(!responseMessage.isSuccess() || null == responseMessage.getData()){
            log.error("获取告警发送邮件地址异常");
            return;
        }
        List<KycDictionary> list = (ArrayList)responseMessage.getData();
        String toEmail = "";
        StringBuffer sb = new StringBuffer();
        for(int i = 0 ; i < list.size() ; i ++){
            KycDictionary kycDictionary = list.get(i);
            if(i == 0){
                toEmail = kycDictionary.getCode();
            }else{
                sb.append(kycDictionary.getCode()).append(",");
            }
        }
        if(sb.length() == 0){
            sendSimpleMail(toEmail,subject,content);
        }else{
            sendSimpleMail(toEmail,subject,content,sb.toString());
        }
    }

    @Override
    public void sendSimpleMail(String to, String subject, String content, String... cc) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(from);
        message.setTo(to);
        message.setCc(cc);
        message.setSubject(subject);
        message.setText(content);
        mailSender.send(message);
    }
}
