package com.js.pay.service.chinapnr.example.pay;

import com.js.common.constant.CommonConstant;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpSendResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * 结汇通知以及主账号余额查询
 */
@Slf4j
@Component
public class ChinaPNRAccountExchange {

    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;

    /**
     * 主账号余额查询
     * @return
     */
    public Map<String,String> queryAccount(){

        Map<String , String>  resMap = new HashMap<>();
        Map<String , String>  parameter = ChinaPNRCommons.getTable(chinaPnrConfigure);
        //交易类别
        parameter.put("TRXTYPE",chinaPnrConfigure.getTrxtypeAcc());

        parameter.put("ACCT_TYPE","001");
        parameter.put("ACCT_CUR","CNY");
        parameter.put("EXT2","EXT2");
        parameter.put("EXT1","EXT1");

        log.info("请求报文 : {}" , parameter );
        HttpSendResult result = ChinaPNRCommons.getSubstituteXml(parameter,
                chinaPnrConfigure.getPosturl(),
                chinaPnrConfigure.getTrxtypeAcc(),chinaPnrConfigure);

        //0001失败0004成功
        if (null == result) {
            resMap.put("code","0001");
            resMap.put("msg","查询-主账号余额异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code","0001");
            resMap.put("msg","查询-主账号余额异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        String respTxt = result.getResponseBody();

        log.info("响应报文：{}",respTxt);
        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            log.info("返回主账号余额查询验签结果:");
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc,chinaPnrConfigure.getChinapnrCer());


        }catch (Exception e){
            log.error("汇付主账号余额返回信息验签异常");
            resMap.put("code", CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付主账号余额返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("汇付主账号余额返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付主账号余额返回信息验签失败");
            return resMap;
        }
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        if(!"1".equals(nodeValue)){
            log.info("汇付主账号余额返回信息失败 status不等于1");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付主账号余额返回信息失败 status不等于1");
            return resMap;
        }

        String nodePath2 = "/RESPONSE/PARAMS/BALANCE";
        String nodeValue2 = ChinaPNRCommons.getNodeValue(resDoc, nodePath2);
        resMap.put("balance",nodeValue2);
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg","成功");
        return resMap;
    }

    /**
     * 结汇回调
     * @return
     */
    public Map<String,String> exchangeCallback(String wholeStr){
        log.info("chinaPnrConfigure:{}",chinaPnrConfigure.toString());
        Map<String , String>  resMap = new HashMap<>();
        boolean veryfyResult = false;
        Document resDoc = null;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(wholeStr.getBytes("UTF-8"))));
            // 解析XML文档
            log.info("结汇回调验签结果:");
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc,chinaPnrConfigure.getChinapnrCer());
        }catch (Exception e){
            log.error("结汇回调返回信息验签异常");
            log.info("结汇回调返回信息验签异常e:{}",e);
            resMap.put("code","0001");
            resMap.put("msg","结汇回调返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("结汇回调返回信息验签失败");
            resMap.put("code","0001");
            resMap.put("msg","结汇回调返回信息验签失败");
            return resMap;
        }
        String nodePath = "/NOTIFY/PARAMS/PAY_AMOUNT";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        resMap.put("payAmount",nodeValue); //到账金额
        resMap.put("code","0004");
        resMap.put("msg","结汇回调成功");
        return resMap;
    }

}
