package com.js.pay.service.chinapnr.example;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 加载汇付配置信息
 */
@Component
@ConfigurationProperties(prefix = "chinapnr")
@Data
public class ChinaPnrConfigure {

    /**
     * #新的代发
     */
    private String newPosturl;
    /**
     * #新的代发查询
     */
    private String  newQueryurl;
    /**
     * 秘钥密码
     */
    private String password;
    /**
     * 秘钥别名
     */
    private String aliasname;
    /**
     * #新版版本
     */
    private String newVersion;
    /**
     * #新版本加密方式
     */
    private String signtype;
    /**
     * #10006050001 商户号
     */
    private String merchantid;
    /**
     *#终端终端号;
     */
    private String terminalid;
    /**
     *#新版代发回调
     */
    private String newResultUrl;
    /**
     *#交易类别 100010 交易明细备案
     */
    private String trxtypeBa;
    /**
     * #交易类别 100040代发
     */
    private String trxtypeDf;
    /**
     *#交易类型
     */
    private String producttype;
    /**
     * #旧版版本
     */
    private String version;
    /**
     * #旧版交易类别 200030代发查询
     */
    private String trxtypeDfcx;
    /**
     * #旧版代发回调路径
     */
    private String oldResultUrl;
    /**
     * #旧版本请求路径
     */
    private String posturl;
    /**
     * 旧版代发查询
     */
    private String queryurl;
    /**
     * stage2
     */
    private String envtype;
    /**
     * #个人开户
     */
    private String opentAccountPersonallPosturl;
    /**
     *#个人开户查询
     */
    private String opentAccountPersonallQueryurl;
    /**
     *#个人开户回调
     */
    private String opentAccountPersonallResultUrl;
    /**
     *#企业开户
     */
    private String opentAccountEnterprisePosturl;
    /**
     *#企业开户查询
     */
    private String opentAccountEnterpriseQueryurl;
    /**
     * #企业开户回调
     */
    private String opentAccountEnterpriseResultUrl;
    /**
     *#交易明细备案回调
     */
    private String transactionDetailResultUrl;
    /**
     *私钥绝对地址
     */
    private String chinapnrPfx;
    /**
     *私钥路径地址，不包括文件名
     */
    private String chinapnrPfxUrl;
    /**
     *公钥地址
     */
    private String chinapnrCer;
    /**
     *#请求旧版各式xml路径
     */
    private String chinapnrrXml;
    /**
     *#旧版回调结果
     */
    private String trxtypeDfhd;
    /**
     *#结汇回调结果
     */
    private String trxtypeJhhd;
    /**
     *#查询余额账户
     */
    private String trxtypeAcc;

    @Override
    public String toString() {
        return "ChinaPnrConfigure{" +
                "newPosturl='" + newPosturl + '\'' +
                ", newQueryurl='" + newQueryurl + '\'' +
                ", password='" + password + '\'' +
                ", aliasname='" + aliasname + '\'' +
                ", newVersion='" + newVersion + '\'' +
                ", signtype='" + signtype + '\'' +
                ", merchantid='" + merchantid + '\'' +
                ", terminalid='" + terminalid + '\'' +
                ", newResultUrl='" + newResultUrl + '\'' +
                ", trxtypeBa='" + trxtypeBa + '\'' +
                ", trxtypeDf='" + trxtypeDf + '\'' +
                ", producttype='" + producttype + '\'' +
                ", version='" + version + '\'' +
                ", trxtypeDfcx='" + trxtypeDfcx + '\'' +
                ", oldResultUrl='" + oldResultUrl + '\'' +
                ", posturl='" + posturl + '\'' +
                ", queryurl='" + queryurl + '\'' +
                ", envtype='" + envtype + '\'' +
                ", opentAccountPersonallPosturl='" + opentAccountPersonallPosturl + '\'' +
                ", opentAccountPersonallQueryurl='" + opentAccountPersonallQueryurl + '\'' +
                ", opentAccountPersonallResultUrl='" + opentAccountPersonallResultUrl + '\'' +
                ", opentAccountEnterprisePosturl='" + opentAccountEnterprisePosturl + '\'' +
                ", opentAccountEnterpriseQueryurl='" + opentAccountEnterpriseQueryurl + '\'' +
                ", opentAccountEnterpriseResultUrl='" + opentAccountEnterpriseResultUrl + '\'' +
                ", transactionDetailResultUrl='" + transactionDetailResultUrl + '\'' +
                ", chinapnrPfx='" + chinapnrPfx + '\'' +
                ", chinapnrPfxUrl='" + chinapnrPfxUrl + '\'' +
                ", chinapnrCer='" + chinapnrCer + '\'' +
                ", chinapnrrXml='" + chinapnrrXml + '\'' +
                ", trxtypeDfhd='" + trxtypeDfhd + '\'' +
                ", trxtypeJhhd='" + trxtypeJhhd + '\'' +
                ", trxtypeAcc='" + trxtypeAcc + '\'' +
                '}';
    }
}
