package com.js.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPayXGantiMoneyService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.resp.AntiSoapResphonse;
import com.js.common.model.vo.JsPayXGServicesRecordVO;
import com.js.common.model.vo.KycXGantiMoneyServiceVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPayXGServicesRecordMapper;
import com.js.dal.dao.model.ChinaPnrTransactionDetail;
import com.js.dal.dao.model.JsPayXGServicesRecord;
import com.js.dal.dao.model.JsSyncAmazonSettlementReport;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import tk.mybatis.mapper.entity.Example;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;

/**
 * @Description: XG服务反洗钱检验
 * @Author: liwm
 * @Create: 2019-08-13
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayXGantiMoneyServiceImpl extends IBaseServiceImpl<JsPayXGServicesRecord> implements ApiJsPayXGantiMoneyService {

    @Value("${js.XGService.webServiceUrl}")
    private String webServiceUrl;

    @Value("${js.XGService.soapActionUrl}")
    private String soapActionUrl;
    @Value("${js.XGService.clientID}")
    private String clientID;
    @Value("${js.XGService.password}")
    private String password;
    @Value("${js.XGService.userID}")
    private String userID;
    @Value("${js.XGService.userID}")
    private String predefinedSearchName;


    @Autowired
    private JsPayXGServicesRecordMapper jsPayXGServicesRecordMapper;

    /**
     * 查看XG反洗钱审核记录信息(最近一条)
     * @param kycNaturalId
     * @return
     */
    @Override
    public JsPayXGServicesRecordVO queryXGServicesRecords(String kycNaturalId) {
        log.info("查看XG反洗钱审核记录信息 kycNaturalId:{} , Start: ", kycNaturalId);
        Example example = new Example(JsPayXGServicesRecord.class);
        example.setOrderByClause("create_dts desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andEqualTo("delFlag", "0");
        JsPayXGServicesRecord jsPayXGServicesRecord = jsPayXGServicesRecordMapper.selectOneByExample(example);
        if(jsPayXGServicesRecord == null){
            return null;
        }
        JsPayXGServicesRecordVO jsPayXGServicesRecordVO = new JsPayXGServicesRecordVO();
        BeanUtils.copyProperties(jsPayXGServicesRecord,jsPayXGServicesRecordVO);
        return jsPayXGServicesRecordVO;
    }

    @Override
    public ResponseMessage updateXGServicesStatusById(String id,String status){
        log.info("反洗钱账户审核，id ={},审核 status结果为 {}:", id ,status);
        String result = "0";
        try {
            Example example = new Example(JsPayXGServicesRecord.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("id", id);
            JsPayXGServicesRecord jsPayXGServicesRecord = new JsPayXGServicesRecord();
            jsPayXGServicesRecord.setStatus(status);
            result = jsPayXGServicesRecordMapper.updateByExampleSelective(jsPayXGServicesRecord, example)+"";
        }catch (Exception e){
            log.error("反洗钱账户审核出错，id ={},Exception:{}", id ,e);
            e.printStackTrace();
            return ResultUtil.error(ResultEnum.ERROR);
        }
        return ResultUtil.success( result ,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage searchKycForXGantiMoney(KycXGantiMoneyServiceVO kycXGantiMoneyServiceVO) {
        log.info("反洗钱账户 {} 信息查询start:", JSON.toJSONString(kycXGantiMoneyServiceVO));
        String xml = "";
        if("0".equals(kycXGantiMoneyServiceVO.getEntityType())){
            xml = searchXmlForIndividual(kycXGantiMoneyServiceVO);
        }else if("1".equals(kycXGantiMoneyServiceVO.getEntityType())){
            xml = searchXmlForBussies(kycXGantiMoneyServiceVO);
        }else{
            return ResultUtil.error(ResultEnum.ERROR);
        }
        String resphonse = httpSendSoapPost(xml);
        if(StringUtils.isEmpty(resphonse)){
            return ResultUtil.error(ResultEnum.ERROR);
        }
        JsPayXGServicesRecord jsPayXGServicesRecord = new JsPayXGServicesRecord();
        BeanUtils.copyProperties(kycXGantiMoneyServiceVO,jsPayXGServicesRecord);
        if(resphonse.contains("Records") && resphonse.contains("RecordDetails")){
            jsPayXGServicesRecord.setStatus(CertiStatusEnum.AUDIT_UNKNOWN.toString());
        }else{
            jsPayXGServicesRecord.setStatus(CertiStatusEnum.AUDIT_PASS.toString());
        }
        jsPayXGServicesRecord.setRequest(xml);
        jsPayXGServicesRecord.setResponseStatusCode("200");
        jsPayXGServicesRecord.setResphonse(resphonse);
        insertSelective(jsPayXGServicesRecord);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }


    /**
     * Http协议请求 XG Services 查询反洗钱账户信息
     * @param xml
     * @return
     */
    private String httpSendSoapPost(String xml){
        log.info("ApiJsPayXGantiMoneyServiceImpl-httpSendSoapPost 反洗钱 requestXml:{} ," , xml);
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedReader br = null;
        String result = null;// 返回结果字符串
        OutputStream out = null;
        AntiSoapResphonse antiSoapResphonse = null;
        try {
            URL url = new URL(webServiceUrl);
            // 通过远程url连接对象打开一个连接，强转成httpURLConnection类
            connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
            connection.setRequestProperty("SOAPAction",soapActionUrl ); // "https://bridgerinsight.lexisnexis.com/BridgerInsight.Web.Services.Interfaces.11.0/ISearch/Search");
            // 设置连接主机服务器的超时时间：60000毫秒
            connection.setConnectTimeout(60000);
            // 设置读取远程返回的数据时间：60000毫秒
            connection.setReadTimeout(60000);
            connection.connect();
            out = connection.getOutputStream(); // 获取输出流对象
            connection.getOutputStream().write(xml.getBytes("UTF-8")); // 将要提交服务器的SOAP请求字符流写入输出流
            out.flush();
            out.close();
            log.info("XGServices服务ResponseCode：{} ，",connection.getResponseCode());
            // 通过connection连接，获取输入流
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
                // 封装输入流is，并指定字符集
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                // 存放数据
                StringBuffer sbf = new StringBuffer();
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\r\n");
                }
                result = sbf.toString();
            }else{
                log.error("XGServices 服务ResponseCode：{} ，ResponseMessage:{} ,",connection.getResponseCode(), connection.getResponseMessage());
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
            log.error("XGServices服务httpSendSoapPost MalformedURLException:{}" ,e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            log.error("XGServices服务httpSendSoapPost IOException:{}" ,e.getMessage());
        } finally {
            if (null != br) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            connection.disconnect();// 关闭远程连接
        }
        return result;
    }

    /**
     * 反洗钱请求报文 XML格式
     * @param kycXGantiMoneyServiceVO 数据封装VO
     * @return
     */
    private String searchXmlForBussies(KycXGantiMoneyServiceVO kycXGantiMoneyServiceVO){
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:brid=\"https://bridgerinsight.lexisnexis.com/BridgerInsight.Web.Services.Interfaces.11.0\">");
        sb.append("<soapenv:Header/><soapenv:Body><brid:Search><brid:context>");
        sb.append("<brid:ClientID>"+clientID+"</brid:ClientID>");
        sb.append("<brid:Password>"+password+"</brid:Password>");
        sb.append("<brid:UserID>"+userID+"</brid:UserID>");
        sb.append("</brid:context><brid:config><brid:AssignResultTo>");
        sb.append("<brid:EmailNotification>true</brid:EmailNotification>");
        sb.append("<brid:RolesOrUsers><brid:string>Administrator</brid:string>");
        sb.append("</brid:RolesOrUsers>");
        sb.append("<brid:Type>Role</brid:Type></brid:AssignResultTo>");
        sb.append("<brid:PredefinedSearchName>"+predefinedSearchName+"</brid:PredefinedSearchName>");
        sb.append("<brid:WriteResultsToDatabase>true</brid:WriteResultsToDatabase>");
        sb.append("</brid:config><brid:input><brid:Records><brid:InputRecord><brid:Entity><brid:AdditionalInfo><brid:InputAdditionalInfo>");
        sb.append("<brid:Type>DOB</brid:Type></brid:InputAdditionalInfo>");
        sb.append("</brid:AdditionalInfo><brid:Addresses><brid:InputAddress>");
        sb.append("<brid:FullAddress>"+kycXGantiMoneyServiceVO.getAddress()+"</brid:FullAddress>");
        sb.append("<brid:Type>Current</brid:Type></brid:InputAddress></brid:Addresses>");
        sb.append("<brid:EntityType>Individual</brid:EntityType><brid:IDs>");
        sb.append("<brid:Number>"+kycXGantiMoneyServiceVO.getOrgCode()+"</brid:Number>");
        sb.append("<brid:Type>National</brid:Type></brid:IDs><brid:Name>");
        sb.append("<brid:Full>"+kycXGantiMoneyServiceVO.getEnterpriseName()+"</brid:Full>");
        sb.append("</brid:Name></brid:Entity></brid:InputRecord></brid:Records></brid:input></brid:Search></soapenv:Body></soapenv:Envelope>");
        return sb.toString();
    }

    private String searchXmlForIndividual(KycXGantiMoneyServiceVO kycXGantiMoneyServiceVO){
        StringBuilder sb=new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:brid=\"https://bridgerinsight.lexisnexis.com/BridgerInsight.Web.Services.Interfaces.11.0\">");
        sb.append("<soapenv:Header/><soapenv:Body><brid:Search><brid:context>");
        sb.append("<brid:ClientID>"+clientID+"</brid:ClientID>");
        sb.append("<brid:Password>"+password+"</brid:Password>");
        sb.append("<brid:UserID>"+userID+"</brid:UserID>");
        sb.append("</brid:context><brid:config><brid:AssignResultTo>");
        sb.append("<brid:EmailNotification>true</brid:EmailNotification>");
        sb.append("<brid:RolesOrUsers><brid:string>Administrator</brid:string>");
        sb.append("</brid:RolesOrUsers>");
        sb.append("<brid:Type>Role</brid:Type></brid:AssignResultTo>");
        sb.append("<brid:PredefinedSearchName>"+predefinedSearchName+"</brid:PredefinedSearchName>");
        sb.append("<brid:WriteResultsToDatabase>true</brid:WriteResultsToDatabase>");
        sb.append("</brid:config><brid:input><brid:Records><brid:InputRecord><brid:Entity><brid:AdditionalInfo><brid:InputAdditionalInfo>");
        sb.append("<brid:Label></brid:Label>");
        sb.append("<brid:Value></brid:Value>");
        sb.append("<brid:Type>DOB</brid:Type></brid:InputAdditionalInfo>");
        sb.append("</brid:AdditionalInfo><brid:Addresses><brid:InputAddress>");
        sb.append("<brid:FullAddress>"+kycXGantiMoneyServiceVO.getAddress()+"</brid:FullAddress>");
        sb.append("<brid:Type>Current</brid:Type></brid:InputAddress></brid:Addresses>");
        sb.append("<brid:EntityType>Individual</brid:EntityType><brid:IDs>");
        sb.append("<brid:Number>"+kycXGantiMoneyServiceVO.getCardId()+"</brid:Number>");
        sb.append("<brid:Type>National</brid:Type></brid:IDs><brid:Name>");
        sb.append("<brid:Full>"+kycXGantiMoneyServiceVO.getFullName()+"</brid:Full>");
        sb.append("</brid:Name></brid:Entity></brid:InputRecord></brid:Records></brid:input></brid:Search></soapenv:Body></soapenv:Envelope>");
        return sb.toString();
    }

}
