package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 交易流水操作具体实现
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPayTradeServiceImpl extends IBaseServiceImpl<JsPayTrade> implements ApiJsPayTradeService {
    @Autowired
    ApiJsPaySunrateBankServiceImpl apiJsPaySunrateBankServiceimpl;
    @Autowired
    ApiJsPaySysAcctServiceImpl apiJsPaySysAcctServiceImpl;
    @Autowired
    ApiJsPayUserAcctServiceImpl apiJsPayUserAcctServiceImpl;
    @Autowired
    ApiJsPayUserAcctService apiJsPayUserAcctService;
    @Autowired
    ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;
    @Autowired
    ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;
    @Autowired
    ApiKycBankService apiKycBankService;
    @Autowired
    ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Autowired
    ApiIMailService apiIMailService;

    @Override
    public ResponseMessage jsPayTradeAdd(JsPayTradeReq jsPayTradeReq) {
        JsPayTrade jsPayTrade = new JsPayTrade();
        BeanUtils.copyProperties(jsPayTradeReq,jsPayTrade);
        jsPayTrade.setId(IdUtil.simpleUUID());
        jsPayTrade.setCreateDts(new Date());
        super.insertSelective(jsPayTrade);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    public ResponseMessage jsPayWithdrawTradeAdd(Map<String,Object> paramsMap,List<JsPayTradeReq> jsPayTradeReqList){
        JsPaySysAcctVO jsPaySysAcctVOYFJSRATE = (JsPaySysAcctVO)paramsMap.get("jsPaySysAcctVOYFJSRATE");
        JsPaySysAcctVO jsPaySysAcctVOYFJS = (JsPaySysAcctVO)paramsMap.get("jsPaySysAcctVOYFJS");
        JsPaySysAcct jsPaySysAcctYFJSRATE = new JsPaySysAcct();
        jsPaySysAcctYFJSRATE.setId(jsPaySysAcctVOYFJSRATE.getId());
        jsPaySysAcctYFJSRATE.setAvailableAmt(jsPaySysAcctVOYFJSRATE.getAvailableAmt());
        int updateCountYFJSRATE = apiJsPaySysAcctServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySysAcctYFJSRATE);
        JsPaySysAcct jsPaySysAcctYFJS = new JsPaySysAcct();
        jsPaySysAcctYFJS.setId(jsPaySysAcctVOYFJS.getId());
        jsPaySysAcctYFJS.setAvailableAmt(jsPaySysAcctVOYFJS.getAvailableAmt());
        int updateCountYFJS = apiJsPaySysAcctServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySysAcctYFJS);
        log.info("更新汇差账户信息条数:{},更新记账账户条数：{}",updateCountYFJSRATE,updateCountYFJS);
        jsPayTradeReqList.stream().forEach(jsPayTradeReq -> {
            JsPayTrade jsPayTrade = new JsPayTrade();
            BeanUtils.copyProperties(jsPayTradeReq,jsPayTrade);
            jsPayTrade.setId(IdUtil.simpleUUID());
            iBaseMapper.insertSelective(jsPayTrade);
        });
        log.info("提现出账批量插入流水信息完成");
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    //汇付新旧代发接口回调js内部处理方法
    public void hfgjCallbackSubstituteJsPayTrade(List<ChinaPNRBatchDetailedPay> detailList,String batchNo,String detailsCallback){
        try {
            JsPayTrade jsPayTradeQuery = new JsPayTrade();
            jsPayTradeQuery.setTradeNo(batchNo);
            List<JsPayTrade> jsPayTradeList = iBaseMapper.select(jsPayTradeQuery);
            if (CollectionUtils.isEmpty(jsPayTradeList)) {
                log.error("根据批次号未查询到批次流水信息:{}", batchNo);
                apiIMailService.sendRemindEmail("汇付旧版代发回调异常", "汇付旧版代发回调根据批次号未查询到批次流水信息,批次号:" + batchNo, EmailRemindTypeEnum.WARN_EMAIL);
                return;
            }
            JsPayTrade jsPayTradeProcess = null;
            for (ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay : detailList) {
                for (JsPayTrade jsPayTrade : jsPayTradeList) {
                    if (jsPayTrade.getSubstituteDetailId().equals(chinaPNRBatchDetailedPay.getDetailedId())) {
                        jsPayTrade.setProcessStatus("030".equals(chinaPNRBatchDetailedPay.getStatus()) ? ProcessStatusEnum.TRADE_PROCESSED_FAILURE : "040".equals(chinaPNRBatchDetailedPay.getStatus()) ? ProcessStatusEnum.TRADE_PROCESSED : ProcessStatusEnum.TRADE_UNPROCESSED);
                        iBaseMapper.updateByPrimaryKeySelective(jsPayTrade);
                        if (TradeSubTypeEnum.WITHDRAW.equals(jsPayTrade.getTradeSubType())) {
                            //代发回调，则获取客户账户提现流水
                            jsPayTradeProcess = jsPayTrade;
                        }
                        break;
                    }
                }
            }
            if (null != jsPayTradeProcess && ProcessStatusEnum.TRADE_PROCESSED.equals(jsPayTradeProcess.getProcessStatus())) {
                oldSubstituteTrade(jsPayTradeProcess);
            }
            if (StringUtils.isNotBlank(detailsCallback)) {
                log.error("代发存在失败记录，请及时处理,批次号:{}", batchNo, EmailRemindTypeEnum.WARN_EMAIL);
                apiIMailService.sendRemindEmail("汇付旧版代发回调异常", "代发存在失败记录，请及时处理,批次号:" + batchNo, EmailRemindTypeEnum.WARN_EMAIL);
            }
        }catch (Exception ex){
            log.error("汇付新旧代发接口回调js内部处理方法异常：", ex);
            apiIMailService.sendRemindEmail("汇付新旧代发接口回调js内部处理方法异常", "汇付新旧代发接口回调js内部处理方法异常:" + ex.getMessage(), EmailRemindTypeEnum.WARN_EMAIL);
        }
    }

    private void oldSubstituteTrade(JsPayTrade jsPayTrade){
        log.info("汇付旧版代发回调提现结果处理流程-开始:{}",jsPayTrade);
        JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq = new JsPaySunrateBankTradeOutReq();
        jsPaySunrateBankTradeOutReq.setTxnNo(jsPayTrade.getTxnNo());
        jsPaySunrateBankTradeOutReq.setLockNo(jsPayTrade.getLockNo());
        JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = apiJsPaySunrateTradeLockPriceService.findTradeLockInfo(jsPaySunrateBankTradeOutReq);
        if(null == jsPaySunrateTradeLockPriceVO){
            log.error("未查询到锁汇交易信息,lockNo:{},txnNo:{}",jsPayTrade.getLockNo(),jsPayTrade.getTxnNo());
            apiIMailService.sendRemindEmail("汇付旧版代发回调提现结果处理异常","未查询到锁汇交易信息,params:" + JSON.toJSONString(jsPaySunrateBankTradeOutReq),EmailRemindTypeEnum.WARN_EMAIL);
            return;
        }
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setKycNaturalId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateTradeLockPriceVO.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateTradeLockPriceVO.getSubAcctNo());
        jsPaySunrateBankQuery.setDelFlag(false);
        JsPaySunrateBank jsPaySunrateBank = apiJsPaySunrateBankServiceimpl.getiBaseMapper().selectOne(jsPaySunrateBankQuery);
        if (null == jsPaySunrateBank) {
            log.error("未查询到寻汇虚拟账户信息:{}", JSON.toJSONString(jsPaySunrateBankQuery));
            apiIMailService.sendRemindEmail("汇付旧版代发回调提现结果处理异常","未查询到寻汇收款账户信息,params:" + JSON.toJSONString(jsPaySunrateBankQuery),EmailRemindTypeEnum.WARN_EMAIL);
            return;
        }
        log.info("查询到寻汇虚拟账户信息：{}",jsPaySunrateBank);
        if(jsPaySunrateTradeLockPriceVO.getTxnAmt().compareTo(jsPaySunrateBank.getFreezedBalance()) > 1){
            log.error("解冻金额异常{}", JSON.toJSONString(jsPaySunrateBankQuery));
            log.error("解冻金额异常txnAmt:{},freezedAmt:{}", jsPaySunrateTradeLockPriceVO.getTxnAmt(),jsPaySunrateBank.getFreezedBalance());
            apiIMailService.sendRemindEmail("汇付旧版代发回调提现结果处理异常","解冻金额异常,寻汇收款账户剩余冻结金额，与 需要解冻金额 不否和" + JSON.toJSONString(jsPaySunrateBankQuery),EmailRemindTypeEnum.WARN_EMAIL);
            return;
        }
        jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        log.info("提现完成：处理前余额：{}，冻结金额：{}，需解冻金额：{}",jsPaySunrateBank.getCurrentBalance(),jsPaySunrateBank.getFreezedBalance(),jsPaySunrateTradeLockPriceVO.getTxnAmt());
        jsPaySunrateBank.setCurrentBalance(jsPaySunrateBank.getCurrentBalance().subtract(jsPaySunrateTradeLockPriceVO.getTxnAmt()));
        jsPaySunrateBank.setFreezedBalance(jsPaySunrateBank.getFreezedBalance().subtract(jsPaySunrateTradeLockPriceVO.getTxnAmt()));
        log.info("提现完成：处理后余额：{}，冻结金额：{}",jsPaySunrateBank.getCurrentBalance(),jsPaySunrateBank.getFreezedBalance());
        int updateOutCount = apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
        jsPaySunrateBank.setUpdateDts(new Date());
        int updateSunrateBankCount = apiJsPaySunrateBankServiceimpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySunrateBank);
        log.info("提现到银行卡操作完成，更新jsPaySunrateBankLockPrice条数：{},更新jsPaySunrateBank条数：{}",updateOutCount,updateSunrateBankCount);
        log.info("汇付旧版代发回调提现结果处理流程-结束");
    }

    @Override
    public ResponseMessage withdrawBySunrateRouteType(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO) {
        log.info("走寻汇提现操作出账处理流程-开始lockPrice:{}",jsPaySunrateTradeLockPriceVO);
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setKycNaturalId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateTradeLockPriceVO.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateTradeLockPriceVO.getSubAcctNo());
        jsPaySunrateBankQuery.setDelFlag(false);
        JsPaySunrateBank jsPaySunrateBank = apiJsPaySunrateBankServiceimpl.getiBaseMapper().selectOne(jsPaySunrateBankQuery);
        if (null == jsPaySunrateBank) {
            log.error("未查询到寻汇虚拟账户信息:{}", JSON.toJSONString(jsPaySunrateBankQuery));
            jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
            int updateOutCount = apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
            log.info("提现到银行卡操作异常，更新jsPaySunrateBankLockPrice条数：{}",updateOutCount);
            apiIMailService.sendRemindEmail("汇付旧版代发回调提现结果处理异常","未查询到寻汇虚拟账户信息,params:" + JSON.toJSONString(jsPaySunrateBankQuery),EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
        log.info("查询到寻汇虚拟账户信息：{}",jsPaySunrateBank);
        if(jsPaySunrateTradeLockPriceVO.getTxnAmt().compareTo(jsPaySunrateBank.getFreezedBalance()) > 1){
            log.error("解冻金额异常{}", JSON.toJSONString(jsPaySunrateBankQuery));
            log.error("解冻金额异常txnAmt:{},freezedAmt:{}", jsPaySunrateTradeLockPriceVO.getTxnAmt(),jsPaySunrateBank.getFreezedBalance());
            jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
            int updateOutCount = apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
            log.info("提现到银行卡操作异常，更新jsPaySunrateBankLockPrice条数：{}",updateOutCount);
            apiIMailService.sendRemindEmail("汇付旧版代发回调提现结果处理异常","解冻金额异常,寻汇收款账户剩余冻结金额，与 需要解冻金额 不否和" + JSON.toJSONString(jsPaySunrateBankQuery),EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
        jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        log.info("提现完成：处理前余额：{}，冻结金额：{}，需解冻金额：{}",jsPaySunrateBank.getCurrentBalance(),jsPaySunrateBank.getFreezedBalance(),jsPaySunrateTradeLockPriceVO.getTxnAmt());
        jsPaySunrateBank.setCurrentBalance(jsPaySunrateBank.getCurrentBalance().subtract(jsPaySunrateTradeLockPriceVO.getTxnAmt()));
        jsPaySunrateBank.setFreezedBalance(jsPaySunrateBank.getFreezedBalance().subtract(jsPaySunrateTradeLockPriceVO.getTxnAmt()));
        log.info("提现完成：处理后余额：{}，冻结金额：{}",jsPaySunrateBank.getCurrentBalance(),jsPaySunrateBank.getFreezedBalance());
        int updateOutCount = apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
        int updateSunrateBankCount = apiJsPaySunrateBankServiceimpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySunrateBank);
        log.info("提现到银行卡操作完成，更新jsPaySunrateBankLockPrice条数：{},更新jsPaySunrateBank条数：{}",updateOutCount,updateSunrateBankCount);
        log.info("走寻汇提现操作出账处理流程-结束");
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
