package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description: 预锁汇处理接口具体实现
 * @Author: liuh
 * @Create: 2019-9-9
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySunrateTradeLockPricePreServiceImpl extends IBaseServiceImpl<JsPaySunrateTradeLockPricePre> implements ApiJsPaySunrateTradeLockPricePreService {
    @Autowired
    ApiJsPaySunrateBankServiceImpl apiJsPaySunrateBankServiceImpl;
    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Autowired
    ApiJsSystemHolidaysService apiJsSystemHolidaysService;
    @Autowired
    ApiJsKycChargeService apiJsKycChargeService;

    @Override
    public ResponseMessage lockPricePre(JsPaySunrateTradeLockPricePreReq jsPaySunrateTradeLockPricePreReq) {
        log.info("锁汇预处理开始入参:{}",jsPaySunrateTradeLockPricePreReq);
        String kycSunrateBankId = jsPaySunrateTradeLockPricePreReq.getKycSunrateBankId();
        BigDecimal txnAmt = jsPaySunrateTradeLockPricePreReq.getTxnAmt();
        JsPaySunrateBank jsPaySunrateBank = apiJsPaySunrateBankServiceImpl.getiBaseMapper().selectByPrimaryKey(kycSunrateBankId);
        if(null == jsPaySunrateBank){
            log.error("未查询到虚拟账户信息kycSunrateBankId：{}",kycSunrateBankId);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),"未查询到虚拟账户信息kycSunrateBankId：" + kycSunrateBankId);
        }

        jsPaySunrateBank.setAvailableBalance(jsPaySunrateBank.getAvailableBalance().subtract(txnAmt));
        jsPaySunrateBank.setFreezedBalance(jsPaySunrateBank.getFreezedBalance().add(txnAmt));
        jsPaySunrateBank.setUpdateDts(new Date());
        int updateSunrateBankCount = apiJsPaySunrateBankServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySunrateBank);
        log.info("更新虚拟账户条数：{}",updateSunrateBankCount);
        JsPaySunrateTradeLockPricePre jsPaySunrateTradeLockPricePre = new JsPaySunrateTradeLockPricePre();
        BeanUtils.copyProperties(jsPaySunrateTradeLockPricePreReq,jsPaySunrateTradeLockPricePre);
        jsPaySunrateTradeLockPricePre.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeLockPricePre.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeLockPricePre.setOrgCode(jsPaySunrateBank.getOrgCode());
        jsPaySunrateTradeLockPricePre.setSubAcctNo(jsPaySunrateBank.getSubAcctNo());
        jsPaySunrateTradeLockPricePre.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);
        jsPaySunrateTradeLockPricePre.setSellCur(jsPaySunrateBank.getCurId());
        jsPaySunrateTradeLockPricePre.setKycNaturalId(jsPaySunrateBank.getKycNaturalId());
        jsPaySunrateTradeLockPricePre.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeLockPricePre.setKycSunrateStoreId(jsPaySunrateBank.getKycSunrateStoreId());
        jsPaySunrateTradeLockPricePre.setTxnAmt(txnAmt);
        jsPaySunrateTradeLockPricePre.setSellAmt(txnAmt);
        jsPaySunrateTradeLockPricePre.setTxnMode(CommonConstant.TXN_MODE_SELL);
        jsPaySunrateTradeLockPricePre.setSunrateBankAvailableBalance(jsPaySunrateBank.getAvailableBalance());
        jsPaySunrateTradeLockPricePre.setSunrateBankCurrentBalance(jsPaySunrateBank.getCurrentBalance());
        jsPaySunrateTradeLockPricePre.setProcessStatus(ProcessStatusEnum.TRADE_UNPROCESSED);
        int insertCount = iBaseMapper.insertSelective(jsPaySunrateTradeLockPricePre);
        log.info("插入预计算锁汇数据条数：{}",insertCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
