package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiHKPersonalService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycCertiHKPersonalReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiHKPersonal;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycSunrateRegister;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;


/**
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiHKPersonalServiceImpl extends IBaseServiceImpl<KycCertiHKPersonal> implements ApiKycCertiHKPersonalService {
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    ApiSunrateRegisterServiceImpl apiSunrateRegisterServiceImpl;
    @Autowired
    ApiKycCertiLinkFilelServiceImpl apiKycCertiLinkFilelServiceImpl;

    @Override
    public ResponseMessage certiHKPersonalAdd(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO){
        log.info("香港个人-实名认证提交处理开始:{}", JSON.toJSONString(kycCertiHKPersonalReq));
        KycCertiHKPersonal kycCertiHKPersonal = new KycCertiHKPersonal();
        BeanUtils.copyProperties(kycCertiHKPersonalReq,kycCertiHKPersonal);

        kycCertiHKPersonal.setId(IdUtil.simpleUUID());
        kycCertiHKPersonal.setKycNaturalId(kycNaturalVO.getId());
        kycCertiHKPersonal.setCreateId(kycNaturalVO.getId());
        kycCertiHKPersonal.setIdType(kycCertiHKPersonalReq.getCertiCardType().name());
        kycCertiHKPersonal.setIdTypeName(kycCertiHKPersonalReq.getCertiCardType().getEnumName());
        kycCertiHKPersonal.setCreateName(kycNaturalVO.getCertificationName());

        super.insertSelective(kycCertiHKPersonal);
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiHKPersonal.getId(), kycNaturalVO, kycCertiHKPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港个人实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_FIRST_TRIAL);
        kycNaturalReq.setRegisterType(RegisterType.HK_PERSONAL);
        kycNaturalReq.setCertificationName(kycCertiHKPersonalReq.getCusName());
        kycNaturalReq.setIdNo(kycCertiHKPersonalReq.getCertificateNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiHKPersonal.getId());
    }

    @Override
    public boolean verifyCertiHKPersonalExists(String certificateNo) {
        KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
        kycCertiHKPersonalQuery.setCertificateNo(certificateNo);
        KycCertiHKPersonal kycCertiHKPersonal = iBaseMapper.selectOne(kycCertiHKPersonalQuery);
        boolean result = null == kycCertiHKPersonal ? false : true;
        if(!result){
            KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
            kycSunrateRegisterQuery.setOrgCode(certificateNo);
            KycSunrateRegister kycSunrateRegister = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQuery);
            result = null == kycSunrateRegister ? false : true;
        }
        return result;
    }

    @Override
    public ResponseMessage certiHKPersonalUpdate(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("香港个人-实名认证编辑处理开始:{}", JSON.toJSONString(kycCertiHKPersonalReq));
        KycCertiHKPersonal kycCertiHKPersonalSel = iBaseMapper.selectByPrimaryKey(kycCertiHKPersonalReq.getId());
        if(null == kycCertiHKPersonalSel){
            log.error("根据主键未查询到实名认证信息：{}",kycCertiHKPersonalReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(kycCertiHKPersonalReq,kycCertiHKPersonalSel);
        kycCertiHKPersonalSel.setUpdateId(kycNaturalVO.getId());
        kycCertiHKPersonalSel.setUpdateName(kycNaturalVO.getCertificationName());
        kycCertiHKPersonalSel.setUpdateDts(new Date());
        int updateCertiCount = iBaseMapper.updateByPrimaryKeySelective(kycCertiHKPersonalSel);
        log.info("更新certihkperson表记录：{}条",updateCertiCount);
        KycCertiLinkFile kycCertiLinkFileDel = new KycCertiLinkFile();
        kycCertiLinkFileDel.setKycNaturalId(kycNaturalVO.getId());
        kycCertiLinkFileDel.setDelFlag(false);
        List<KycCertiLinkFile> selectList = apiKycCertiLinkFilelServiceImpl.getiBaseMapper().select(kycCertiLinkFileDel);
        selectList.stream().forEach(kycCertiLinkFile -> {
            kycCertiLinkFile.setDelFlag(true);
            kycCertiLinkFile.setUpdateDts(new Date());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(kycCertiLinkFile);
        });
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiHKPersonalReq.getId(), kycNaturalVO, kycCertiHKPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港个人实名认证信息编辑完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_FIRST_TRIAL);
        kycNaturalReq.setRegisterType(RegisterType.HK_PERSONAL);
        kycNaturalReq.setCertificationName(kycCertiHKPersonalReq.getCusName());
        kycNaturalReq.setIdNo(kycCertiHKPersonalReq.getCertificateNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiHKPersonalReq.getId());
    }
}
