package com.js.pay.service.chinapnr.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNRSubstituteDetails;
import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNRBatchDetailedPayMapper;
import com.js.dal.dao.mapper.ChinaPNRBatchPayMapper;
import com.js.dal.dao.model.ChinaPNRBatchDetailedPay;
import com.js.dal.dao.model.ChinaPNRBatchPay;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.pay.ChinaPNRNewSubstitute;
import com.js.pay.service.chinapnr.example.pay.ChinaPNROldSubstitute;
import com.js.pay.service.impl.ApiJsPayTradeServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description:汇付天下业务代发
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ChinaPNRPaySubstituteServiceImpl implements ChinaPNRPaySubstituteService {

    @Autowired
    private ChinaPNRBatchPayMapper chinaPNRBatchPayMapper;

    @Autowired
    private ChinaPNRBatchDetailedPayMapper chinaPNRBatchDetailedPayMapper;
    @Autowired
    private ApiJsPayTradeServiceImpl apiJsPayTradeServiceImpl;
    @Autowired
    private ChinaPNRNewSubstitute chinaPNRNewSubstitute;
    @Autowired
    private ChinaPNROldSubstitute chinaPNROldSubstitute;

    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;



    /**
     * 客户提现
     * @param chinaPNRSubstituteReq
     * @return
     */
    @Override
    public ResponseMessage newSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq) {
        log.info("客户代发客户提现业务执行 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        batchChinaPayInsert(chinaPNRSubstituteReq, chinaPnrConfigure.getNewResultUrl());
        //执行汇付代发功能
        Map<String,String> resMap = chinaPNRNewSubstitute.substitute(chinaPNRSubstituteReq);
        boolean falg = resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS);

        updateBatchChinaPNRPay(resMap,falg,chinaPNRSubstituteReq.getBatchNo());
        log.info("客户代发提现业务执行完毕 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        if(falg){
            return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
    }

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易
     * @param chinaPNRSubstituteReq
     * @return
     */
    @Override
    public ResponseMessage oldSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq) {

        log.info("客户代发业务执行 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        batchChinaPayInsert(chinaPNRSubstituteReq, chinaPnrConfigure.getOldResultUrl());
        //执行汇付代发功能
        Map<String,String> resMap = chinaPNROldSubstitute.substitute(chinaPNRSubstituteReq);
        boolean falg = resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS);

        updateBatchChinaPNRPay(resMap,falg,chinaPNRSubstituteReq.getBatchNo());
        log.info("客代发业务执行完毕 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        if(falg){
            return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
    }

    /**
     * 客户还款汇差等代发通知
     * @param wholeStr
     * @return
     */
    @Override
    public ResponseMessage oldCallbackSubstitute(String wholeStr) {

        log.info("客户旧版代发通知结果  xmlStr:{}" ,wholeStr);
        //签名
        Map<String,String> resMap = chinaPNROldSubstitute.substituteCallback(wholeStr);
        log.info("客户旧版代发验签返回结果resMap:{}" , resMap);
        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
        //查询该批次下的数据
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setBatchNo(resMap.get("batchNo"));
        chinaPNRBatchPay = chinaPNRBatchPayMapper.selectOne(chinaPNRBatchPay);
        if(null == chinaPNRBatchPay){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR.getCode(),"未找到batchNo【"+ resMap.get("batchNo") +"】的交易批次");
        }
        chinaPNRBatchPay.setResponseMessage(resMap.get("resText"));
        String detailsCallback = resMap.get("details");
//        String detailsCallback = null;//"R1002|600|CMB|P|6465767887999|张三|00|342501198888434344|江苏省|南京市|招行银行南京分行城东支行|Test|T10004|ext1|ext2|代发明细流水号重复";
        //查询该批次下的交易明细
        ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
        chinaPNRBatchDetailedPay.setBatchNo(resMap.get("batchNo"));
//        chinaPNRBatchDetailedPay.setBatchNo("94a16a89518a42658de70c7e79b54fc6");
        List<ChinaPNRBatchDetailedPay> detailList = chinaPNRBatchDetailedPayMapper.select(chinaPNRBatchDetailedPay);
        //返回结果明细为空 ，未发现代发错误结果
        if(null == detailsCallback || "".equals(detailsCallback)){
            log.info("回调的交易结果统一成功");
            chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS);//批次成功
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setUpdateDts(new Date());
                if(resMap.get("status").equals("1")){
                    detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS); //成功
                }else{
                    detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR); //成功
                }
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }else{ //有支付错误数据
            log.info("回调的结果查询到失败的交易记录 ：{}" , detailsCallback);
            String[] detailsArr = detailsCallback.split("\n");
            if(detailsArr.length < detailList.size()){
                chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_PART);
            }else{
                chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
            }
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS); //默认都成功
                for(int i = 0; i < detailsArr.length;i++){
                    String [] detailsArr_s = detailsArr[i].split("[|]");
                    log.info("detailedId=" + detail.getDetailedId() + "detailsArr_s[0]=" + detailsArr_s[0]);
                    if(detail.getDetailedId().equals(detailsArr_s[0])){
                        log.info("回调旧版代发结果更新代发明细为失败 detailId:{}" , detail.getDetailedId());
                        detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR); //失败
                    }
                }
                detail.setUpdateDts(new Date());
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }
        chinaPNRBatchPay.setUpdateDts(new Date());
        chinaPNRBatchPayMapper.updateByPrimaryKey(chinaPNRBatchPay);

        //汇付旧代发回调处理完成调用js流水处理接口方法
        if(CollectionUtils.isNotEmpty(detailList)){
            apiJsPayTradeServiceImpl.hfgjCallbackSubstituteJsPayTrade(detailList,chinaPNRBatchDetailedPay.getBatchNo(),detailsCallback);
        }
        //成功后组装回调信息
        String resultXml = ChinaPNRCommons.resultXml("DFHD",chinaPnrConfigure);
        return ResultUtil.success(resultXml,ResultEnum.CHINA_PNR_SUCCESS);
    }

    /**
     * 客户提现代发通知
     * @param map
     * @return
     */
    @Override
    public ResponseMessage newCallbackSubstitute(Map<String, String> map) {
        log.info("客户提现汇差等代发通知结果  resMap :{} " ,map);
        //签名
        Map<String,String> resMap = chinaPNRNewSubstitute.substituteCallback(map);
        log.info("汇付旧版代发回调返回结果resMap:{}",resMap);
        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            log.info("客户还款回调结果错误 错误描述：" + resMap.get("msg"));
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
        //查询该批次下的数据
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setBatchNo(map.get("batchNo"));
        chinaPNRBatchPay = chinaPNRBatchPayMapper.selectOne(chinaPNRBatchPay);
        if(null == chinaPNRBatchPay){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR.getCode(),"未找到提现batchNo【"+ map.get("batchNo") +"】的交易批次");
        }
        //回调明细数据
        String detailsCallback = map.get("details");
        chinaPNRBatchPay.setResponseMessage(resMap.get("resText"));

        //查询该批次下的交易明细
        ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
        chinaPNRBatchDetailedPay.setBatchNo(map.get("batchNo"));
        List<ChinaPNRBatchDetailedPay> detailList = chinaPNRBatchDetailedPayMapper.select(chinaPNRBatchDetailedPay);
        //返回结果明细为空 ，未发现代发错误结果
        if(null == detailsCallback || "".equals(detailsCallback)){
            log.info("回调的交易结果统一成功");
            chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS);//批次成功
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS); //成功
                detail.setUpdateDts(new Date());
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }else{ //有支付错误数据

            String[] detailsArr = detailsCallback.split(";");
            if(detailsArr.length < detailList.size()){
                chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_PART);
            }else{
                chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
            }
            log.info("回调的结果查询到失败的交易记录 ：" + detailsArr.toString());
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS); //默认都成功
                for(int i = 0; i < detailsArr.length;i++){
                    String [] detailsArr_s = detailsArr[i].split("[|]");
                    if(detail.getDetailedId().equals(detailsArr_s[0])){
                        log.info("回调结果更新代发明细为失败 detailId=" + detail.getDetailedId());
                        detail.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR); //失败
                    }
                }
                detail.setUpdateDts(new Date());
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }
        chinaPNRBatchPay.setUpdateDts(new Date());
        chinaPNRBatchPayMapper.updateByPrimaryKey(chinaPNRBatchPay);
        log.info("提现批次回调成功..更新数据");
        return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
    }

    /**
     * 客户提现查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
    public ResponseMessage queryNewSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {

        log.info("客户代发客户提现业务查询执行 ...batchNO=" + chinaPNRSubstituteQueryReq.getBatchNo() + "明细流水：" + chinaPNRSubstituteQueryReq.getRemitNo());
        Map<String,String> res = new HashMap<>();

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setDetailedId(chinaPNRSubstituteQueryReq.getRemitNo());
        selectChinaPNRBatchDetailed.setBatchNo(chinaPNRSubstituteQueryReq.getBatchNo());
        selectChinaPNRBatchDetailed = chinaPNRBatchDetailedPayMapper.selectOne(selectChinaPNRBatchDetailed);

        if(!selectChinaPNRBatchDetailed.getStatus().equals(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS)){
            //执行汇付代发功能查询
            //ChinaPNRNewSubstitute pay = new ChinaPNRNewSubstitute();
            Map<String,String> resMap = chinaPNRNewSubstitute.substituteQuery(chinaPNRSubstituteQueryReq);
            if(CommonConstant.CHINA_RESULT_SUCCESS.equals(resMap.get("code"))){
                if("2".equals(resMap.get("status"))){ //成功
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS);
                }else if("3".equals(resMap.get("status"))){ //失败
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
                }else if("1".equals(resMap.get("status"))){ //处理中
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_APPLY);
                }else{
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_INIT); //初始化
                }
            }
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(selectChinaPNRBatchDetailed); //修改结果
        }
        res.put("detailedId",selectChinaPNRBatchDetailed.getDetailedId());
        res.put("substituteAmt",selectChinaPNRBatchDetailed.getSubstituteAmt().toPlainString());
        res.put("batchNo",selectChinaPNRBatchDetailed.getBatchNo());
        res.put("status",selectChinaPNRBatchDetailed.getStatus());
        return ResultUtil.success(res,ResultEnum.SUCCESS);
    }

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
        public ResponseMessage queryOldSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {

        log.info("客户代发业务查询执行 ...batchNO=" + chinaPNRSubstituteQueryReq.getBatchNo() + "明细流水：" + chinaPNRSubstituteQueryReq.getRemitNo());
        Map<String,String> res = new HashMap<>();

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setBatchNo(chinaPNRSubstituteQueryReq.getBatchNo());
        selectChinaPNRBatchDetailed.setDetailedId(chinaPNRSubstituteQueryReq.getRemitNo());
        selectChinaPNRBatchDetailed = chinaPNRBatchDetailedPayMapper.selectOne(selectChinaPNRBatchDetailed);

        if(!selectChinaPNRBatchDetailed.getStatus().equals("040")){
            //执行汇付代发功能查询
            Map<String,String> resMap = chinaPNROldSubstitute.substituteQuery(chinaPNRSubstituteQueryReq);
            if(resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
                if(resMap.get("status").equals("2")){ //成功
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_SUCCESS);
                }else if(resMap.get("status").equals("3")){ //失败
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
                }else if(resMap.get("status").equals("1")){ //处理中
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_APPLY);
                }else{
                    selectChinaPNRBatchDetailed.setStatus(CommonConstant.CHINA_HANDLE_STATUS_INIT); //初始化
                }
            }
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(selectChinaPNRBatchDetailed); //修改结果
        }
        res.put("detailedId",selectChinaPNRBatchDetailed.getDetailedId());
        res.put("batchNo",selectChinaPNRBatchDetailed.getBatchNo());
        res.put("substituteAmt",selectChinaPNRBatchDetailed.getSubstituteAmt().toPlainString());
        res.put("status",selectChinaPNRBatchDetailed.getStatus());

        return ResultUtil.success(res,ResultEnum.SUCCESS);
    }

    /**
     * 执行代发前初始化批量和明细交易数据
     * @param chinaPNRSubstituteReq
     */
    public void batchChinaPayInsert(ChinaPNRSubstituteReq chinaPNRSubstituteReq,String result_url){
        //执行流水添加到数据库
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setId(IdUtil.simpleUUID());
        chinaPNRBatchPay.setBatchNo(chinaPNRSubstituteReq.getBatchNo());
        chinaPNRBatchPay.setRequestId(chinaPNRSubstituteReq.getRequestId());
        chinaPNRBatchPay.setRequestTime(new Date());
        chinaPNRBatchPay.setPayCur(chinaPNRSubstituteReq.getPayCur());
        chinaPNRBatchPay.setPayCnt(chinaPNRSubstituteReq.getPayTCnt());
        chinaPNRBatchPay.setPayAmt(chinaPNRSubstituteReq.getPayTAmt());
        chinaPNRBatchPay.setRemitType(chinaPNRSubstituteReq.getRemitType());
        chinaPNRBatchPay.setIgnoreFlag("1");//为1时，只要存在错误的明细行则整个批次失败
        chinaPNRBatchPay.setPurpose("代发");
        chinaPNRBatchPay.setNoticeUrl(result_url);
        chinaPNRBatchPay.setReceiveStatus("1");//全部接收成功
        chinaPNRBatchPay.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_INIT); //初始化
        chinaPNRBatchPay.setUpdateDts(new Date());
        chinaPNRBatchPay.setCreateDts(new Date());
        chinaPNRBatchPayMapper.insertSelective(chinaPNRBatchPay);

        List<ChinaPNRSubstituteDetails> substituteDetailsList = chinaPNRSubstituteReq.getDetailsList();
        for(ChinaPNRSubstituteDetails details : substituteDetailsList){
            ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
            chinaPNRBatchDetailedPay.setId(IdUtil.simpleUUID());
            chinaPNRBatchDetailedPay.setBatchNo(chinaPNRSubstituteReq.getBatchNo());
            chinaPNRBatchDetailedPay.setDetailedId(details.getSubstituteDetailId());
            chinaPNRBatchDetailedPay.setSubstituteAmt(details.getSubstituteDetailAmt());
            chinaPNRBatchDetailedPay.setPurpose(details.getPurpose());
            chinaPNRBatchDetailedPay.setStatus(CommonConstant.CHINA_HANDLE_STATUS_INIT);
            chinaPNRBatchDetailedPay.setSubstituteType(details.getSubstituteType()); //交易类型
            chinaPNRBatchDetailedPay.setCreateDts(new Date());
            chinaPNRBatchDetailedPay.setUpdateDts(new Date());
            chinaPNRBatchDetailedPayMapper.insertSelective(chinaPNRBatchDetailedPay);
        }
    }

    /**
     * 代发同步结果后更新交易流水
     * @param resMap
     * @param falg
     * @param batchNo
     */
    public void updateBatchChinaPNRPay(Map<String,String> resMap,boolean falg , String batchNo){
        ChinaPNRBatchPay selectChinaPNRBatch = new ChinaPNRBatchPay();
        selectChinaPNRBatch.setBatchNo(batchNo);
        selectChinaPNRBatch = chinaPNRBatchPayMapper.selectOne(selectChinaPNRBatch);

        if(falg){ //判断是否代发成功
            selectChinaPNRBatch.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_APPLY);
        }else{
            selectChinaPNRBatch.setHandleStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
            selectChinaPNRBatch.setErrorCode(resMap.get("code"));
            selectChinaPNRBatch.setErrorMsg(resMap.get("msg"));
        }
        selectChinaPNRBatch.setRequestMessage(resMap.get("reqText"));
        selectChinaPNRBatch.setResponseMessage(resMap.get("resText"));
        selectChinaPNRBatch.setUpdateDts(new Date());
        chinaPNRBatchPayMapper.updateByPrimaryKey(selectChinaPNRBatch);

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setBatchNo(batchNo);
        List<ChinaPNRBatchDetailedPay> selectChinaPNRBatchDetailedList = chinaPNRBatchDetailedPayMapper.select(selectChinaPNRBatchDetailed);
        for(ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay : selectChinaPNRBatchDetailedList){
            if(falg){
                chinaPNRBatchDetailedPay.setStatus(CommonConstant.CHINA_HANDLE_STATUS_APPLY);
            }else{
                chinaPNRBatchDetailedPay.setStatus(CommonConstant.CHINA_HANDLE_STATUS_ERROR);
            }
            chinaPNRBatchDetailedPay.setUpdateDts(new Date());
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(chinaPNRBatchDetailedPay);
        }
    }
}
