package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiIMailService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.req.SunrateBeneficiaryAuditReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateBeneficiaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsPaySysAcct;
import com.js.dal.dao.model.KycSunrateBeneficiary;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.util.*;

/**
 * @Description: 寻汇-受益人交互具体实现
 * @Author: liuh
 * @Create: 2019-05-30
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiSunrateBeneficiaryServiceImpl extends IBaseServiceImpl<KycSunrateBeneficiary> implements ApiSunrateBeneficiaryService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Autowired
    ApiJsPaySysAcctServiceImpl apiJsPaySysAcctServiceImpl;
    @Autowired
    ApiIMailService apiIMailService;

    /**
     * @Description: 4.1添加受益人（单个）（合作方 -> 寻汇）
     */
    @Override
    public ResponseMessage beneficiaryCreate(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,KycNaturalVO kycNaturalVO){
        try {
            log.info("添加受益人开始：{}",kycSunrateBeneficiaryReq);
            JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateBeneficiaryReq));
            jsonObjectReq.remove("browserIP");
            Map<String, String> mapParams = (Map) jsonObjectReq;
            ResponseMessage responseMessage = kycSunrateService.sendInfoToXh(kycSunrateBeneficiaryReq.getBrowserIP(), "beneficiary.create", "beneficiary/create/", mapParams);
            if (responseMessage.isSuccess()) {
                operationBeneficiary(kycSunrateBeneficiaryReq, responseMessage, kycNaturalVO);
            }
            return responseMessage;
        }catch (Exception ex){
            log.error("添加受益人异常:{}",kycSunrateBeneficiaryReq);
            log.error("添加受益人异常",ex);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg() + ex.getMessage());
        }
    }

    @Override
    public ResponseMessage beneficiaryModify(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,KycNaturalVO kycNaturalVO) {
        if(StringUtils.isBlank(kycSunrateBeneficiaryReq.getBeneficiaryId())){
            ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateBeneficiaryReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        ResponseMessage responseMessage =  kycSunrateService.sendInfoToXh(kycSunrateBeneficiaryReq.getBrowserIP(),"beneficiary.modify","beneficiary/modify/",mapParams);
        if(responseMessage.isSuccess()){
            operationBeneficiary(kycSunrateBeneficiaryReq,responseMessage,kycNaturalVO);
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage beneficiaryList(String orgCode,String browserIP) {
        Map<String,String> mapParams = new HashMap<>();
        mapParams.put("orgCode", orgCode);
        return kycSunrateService.sendInfoToXh(browserIP,"beneficiary.list","beneficiary/list/",mapParams);
    }

    @Override
    public ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateStoreAuditReq) {
        KycSunrateBeneficiary kycSunrateBeneficiaryQuery = new KycSunrateBeneficiary();
        kycSunrateBeneficiaryQuery.setBeneficiaryId(sunrateStoreAuditReq.getBeneficiaryId());
        kycSunrateBeneficiaryQuery.setOrgCode(sunrateStoreAuditReq.getOrgCode());
        KycSunrateBeneficiary kycSunrateBeneficiary = iBaseMapper.selectOne(kycSunrateBeneficiaryQuery);
        if(null == kycSunrateBeneficiary){
            log.error("根据寻汇受益人审核通知入参查找数据信息不存在");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        kycSunrateBeneficiary.setBeneficiaryStatus(sunrateStoreAuditReq.getBeneficiaryStatus());
        kycSunrateBeneficiary.setAuditRemark(sunrateStoreAuditReq.getRemark());
        iBaseMapper.updateByPrimaryKeySelective(kycSunrateBeneficiary);
        return ResultUtil.success(kycSunrateBeneficiary,ResultEnum.SUCCESS);
    }

    @Override
    public List<KycSunrateBeneficiaryVO> beneficiaryListByOrgCode(String orgCode, BeneficiaryTypeEnum beneficiaryTypeEnum,String cur) {
        log.info("根据入参查询受益人信息-开始:{},{}",orgCode,beneficiaryTypeEnum);
        KycSunrateBeneficiary kycSunrateBeneficiaryQuery = new KycSunrateBeneficiary();
        kycSunrateBeneficiaryQuery.setOrgCode(orgCode);
        kycSunrateBeneficiaryQuery.setBeneficiaryType(beneficiaryTypeEnum);
        if (StringUtils.isNotBlank(cur)){
            if(CommonConstant.TRADE_CURRENCY_CNY.equals(cur)){
                cur = CommonConstant.TRADE_CURRENCY_CNH;
            }
            kycSunrateBeneficiaryQuery.setCur(cur);
        }
        List<KycSunrateBeneficiary> list = iBaseMapper.select(kycSunrateBeneficiaryQuery);
        List<KycSunrateBeneficiaryVO> resultList = new ArrayList<>();
        list.stream().forEach(kycSunrateBeneficiary -> {
            KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = new KycSunrateBeneficiaryVO();
            BeanUtils.copyProperties(kycSunrateBeneficiary,kycSunrateBeneficiaryVO);
            resultList.add(kycSunrateBeneficiaryVO);
        });
        log.info("根据入参查询受益人信息结束:size{}",resultList.size());
        return resultList;
    }

    @Override
    public ResponseMessage beneficiaryCreateMQ(KycNaturalVO kycNaturalVO) {
        JsPaySysAcct jsPaySysAcctQuery = new JsPaySysAcct();
        jsPaySysAcctQuery.setAcctType(JsPaySysAcctTypeEnum.HFGJ_YFJS_BENEFICIARY);
        jsPaySysAcctQuery.setDelFlag(false);
        if(StringUtils.isNotBlank(kycNaturalVO.getJsPaySysAcctId())){
            jsPaySysAcctQuery.setId(kycNaturalVO.getJsPaySysAcctId());
        }
        List<JsPaySysAcct> jsPaySysAcctList = apiJsPaySysAcctServiceImpl.getiBaseMapper().select(jsPaySysAcctQuery);

        if(CollectionUtils.isEmpty(jsPaySysAcctList)){
            log.error("预置受益人账户信息不存在:{}",jsPaySysAcctQuery);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),ResultEnum.MESSAGE_NOT_EXIST.getMsg() + ",acctType:" + JsPaySysAcctTypeEnum.HFGJ_YFJS_BENEFICIARY);
        }
        for(JsPaySysAcct jsPaySysAcct : jsPaySysAcctList){
            log.info("添加受益人信息开始:{}",kycNaturalVO.getOrgCode());
            KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
            kycSunrateBeneficiaryReq.setOrgCode(kycNaturalVO.getOrgCode());
            kycSunrateBeneficiaryReq.setBrowserIP(kycNaturalVO.getBrowserIP());
            kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.PLATEFORM_SELF);
            kycSunrateBeneficiaryReq.setCountryCode(jsPaySysAcct.getReceivingAcctCountry());//国家代码
            kycSunrateBeneficiaryReq.setBankName(jsPaySysAcct.getReceivingBankName());//银行名称
            kycSunrateBeneficiaryReq.setRouteType("3");//路由类型
//            kycSunrateBeneficiaryReq.setAba(JsBeneficiaryConstant.JS_BENEFICIARY_ABA);//ABA
//            kycSunrateBeneficiaryReq.setIban(JsBeneficiaryConstant.JS_BENEFICIARY_IBAN);//IBAN
            kycSunrateBeneficiaryReq.setSwiftcode(jsPaySysAcct.getSwiftCode());//SWIFTCODE
            kycSunrateBeneficiaryReq.setBeneficiaryName(jsPaySysAcct.getAcctName());//受益人名称
            kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(jsPaySysAcct.getAcctNo());//受益人银行账号，iban 包含账号，此处也需要
            kycSunrateBeneficiaryReq.setCur(jsPaySysAcct.getCur());//币种
            kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsPaySysAcct.getReceivingAcctAddr());//受益人地址
            kycSunrateBeneficiaryReq.setRemark("绑定添加受益人");//备注
            ResponseMessage responseMessage = this.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
            log.info("添加受益人信息结束:{}",responseMessage.isSuccess());
            if(!responseMessage.isSuccess()){
                log.error("添加受益人失败");
                apiIMailService.sendRemindEmail("添加受益人异常", "添加受益人失败，请求信息:" + JSON.toJSONString(kycSunrateBeneficiaryReq), EmailRemindTypeEnum.WARN_EMAIL);
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    public void operationBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,ResponseMessage responseMessage,KycNaturalVO kycNaturalVO){
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        if(StringUtils.isBlank(kycSunrateBeneficiaryReq.getBeneficiaryId())){
            KycSunrateBeneficiary kycSunrateBeneficiary = new KycSunrateBeneficiary();
            BeanUtils.copyProperties(kycSunrateBeneficiaryReq,kycSunrateBeneficiary);
            kycSunrateBeneficiary.setId(IdUtil.simpleUUID());
            if(null != kycNaturalVO){
                kycSunrateBeneficiary.setCreateId(kycNaturalVO.getId());
                kycSunrateBeneficiary.setCreateName(kycNaturalVO.getCertificationName());
                kycSunrateBeneficiary.setKycNaturalId(kycNaturalVO.getId());
            }
            kycSunrateBeneficiary.setCreateDts(new Date());
            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
            super.insertSelective(kycSunrateBeneficiary);
        }else{
            KycSunrateBeneficiary kycSunrateBeneficiary = iBaseMapper.selectByPrimaryKey(kycSunrateBeneficiaryReq.getBeneficiaryId());
            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
            iBaseMapper.updateByPrimaryKeySelective(kycSunrateBeneficiary);
        }
    }

    @Override
    public String getKycSunrateBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq){
        PageModel pageModel = new PageModel();
        Example example = new Example(KycSunrateBeneficiary.class);
        example.setOrderByClause("create_dts");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (ObjectUtil.isNotEmpty(kycSunrateBeneficiaryReq.getKycNaturalId())) {
            criteria.andEqualTo("kycNaturalId", kycSunrateBeneficiaryReq.getKycNaturalId());
        }
        if (ObjectUtil.isNotEmpty(kycSunrateBeneficiaryReq.getOrgCode())) {
            criteria.andEqualTo("orgCode", kycSunrateBeneficiaryReq.getOrgCode());
        }
        PageHelper.startPage(kycSunrateBeneficiaryReq.getPageIndex(), kycSunrateBeneficiaryReq.getPageSize());
        List<KycSunrateBeneficiary> beneficiaryList = iBaseMapper.selectByExample(example);
        PageInfo<KycSunrateBeneficiary> pageInfo = new PageInfo<>(beneficiaryList);
        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(beneficiaryList)) {
            List<KycSunrateBeneficiaryVO> beneficiaryVOS = new ArrayList<>();
            beneficiaryList.stream().forEach(kycSunrateBeneficiary -> {
                KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = new KycSunrateBeneficiaryVO();
                BeanUtils.copyProperties(kycSunrateBeneficiary,kycSunrateBeneficiaryVO);
                kycSunrateBeneficiaryVO.setCreateDtsStr(DateUtil.format(kycSunrateBeneficiary.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
                kycSunrateBeneficiaryVO.setUpdateDtsStr(DateUtil.format(kycSunrateBeneficiary.getUpdateDts(), "yyyy-MM-dd HH:mm:ss"));
                beneficiaryVOS.add(kycSunrateBeneficiaryVO);
            });
            pageModel.setList(beneficiaryVOS);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }
}
