package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiJsKycChargeService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.JsKycChargeReq;
import com.js.common.model.vo.JsKycChargeVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsKycCharge;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 用户汇率操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-23
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsKycChargeServiceImpl extends IBaseServiceImpl<JsKycCharge> implements ApiJsKycChargeService {

    @Override
    public JsKycChargeVO findKycChargeInfo(JsKycChargeReq jsKycChargeReq) {
        JsKycCharge jsKycChargeQuery = new JsKycCharge();
        BeanUtils.copyProperties(jsKycChargeReq,jsKycChargeQuery);
        JsKycCharge jsKycCharge = iBaseMapper.selectOne(jsKycChargeQuery);
        if(null == jsKycCharge){
            return null;
        }
        JsKycChargeVO jsKycChargeVO = new JsKycChargeVO();
        BeanUtils.copyProperties(jsKycCharge,jsKycChargeVO);
        return jsKycChargeVO;
    }

    @Override
    public JSONObject findKycChargeList(JsKycChargeReq jsKycChargeReq) {
        JsKycCharge jsKycChargeQuery = new JsKycCharge();
        BeanUtils.copyProperties(jsKycChargeReq,jsKycChargeQuery);
        List<JsKycCharge> jsKycChargeList = iBaseMapper.select(jsKycChargeQuery);
        PageModel pageModel = new PageModel();
        if(CollectionUtils.isEmpty(jsKycChargeList)){
            pageModel.setMsg("暂无数据");
            return JSONObject.parseObject(JSON.toJSONString(pageModel));
        }
        List<JsKycChargeVO> jsKycChargeVOList = new ArrayList<>();
        jsKycChargeList.stream().forEach(jsKycCharge -> {
            JsKycChargeVO jsKycChargeVO = new JsKycChargeVO();
            BeanUtils.copyProperties(jsKycCharge,jsKycChargeVO);
            jsKycChargeVO.setCreateDtsStr(DateUtil.format(jsKycCharge.getCreateDts(),"yyyy-MM-dd HH:ss:mm"));
            jsKycChargeVO.setUpdateDtsStr(DateUtil.format(jsKycCharge.getUpdateDts(),"yyyy-MM-dd HH:ss:mm"));
            jsKycChargeVOList.add(jsKycChargeVO);
        });
        pageModel.setList(jsKycChargeVOList);
        pageModel.setCount(jsKycChargeVOList.size());
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSONObject.parseObject(JSON.toJSONString(pageModel));
    }

    @Override
    public ResponseMessage operateKycChargeInfo(JsKycChargeReq jsKycChargeReq) {
        if(StringUtils.isBlank(jsKycChargeReq.getId())){
            JsKycCharge jsKycChargeQuery = new JsKycCharge();
            jsKycChargeQuery.setKycNaturalId(jsKycChargeReq.getKycNaturalId());
            jsKycChargeQuery.setChargeType(jsKycChargeReq.getChargeType());
            List<JsKycCharge> jsKycChargeList = iBaseMapper.select(jsKycChargeQuery);
            if(CollectionUtils.isNotEmpty(jsKycChargeList)){
                log.error("{}该用户已配置{}类型收费信息不予新增处理",jsKycChargeReq.getKycNaturalId(),jsKycChargeReq.getChargeType());
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(),"该用户已配置此收费信息");
            }
            jsKycChargeQuery.setId(IdUtil.simpleUUID());
            jsKycChargeQuery.setChargeScale(jsKycChargeReq.getChargeScale());
            jsKycChargeQuery.setBelongToType("SELF");
            jsKycChargeQuery.setStoreTheSite(SiteEnum.NORTH_AMERICA_SITE);
            jsKycChargeQuery.setCreateId(jsKycChargeReq.getKycNaturalId());
            jsKycChargeQuery.setJsRemark("SERVICE_CHARGE".equals(jsKycChargeReq.getChargeType()) ? "手续费扣比" : "汇差扣比");
            int insertCount = iBaseMapper.insertSelective(jsKycChargeQuery);
            log.info("新增用户收费配置信息条数：{}",insertCount);
        }else{
            JsKycCharge jsKycCharge = new JsKycCharge();
            jsKycCharge.setId(jsKycChargeReq.getId());
            jsKycCharge.setChargeScale(jsKycChargeReq.getChargeScale());
            int updateCount = iBaseMapper.updateByPrimaryKeySelective(jsKycCharge);
            log.info("更新用户收费配置信息条数：{}",updateCount);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
