package com.js.pay.service.chinapnr.impl;

import com.js.api.jspay.service.chinapnr.ChinaPNRAccountExchangeService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.pay.ChinaPNRAccountExchange;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * @Description:汇结和主账号查询
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ChinaPNRAccountExchangeServiceImpl implements ChinaPNRAccountExchangeService {

    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;
    @Autowired
    private ChinaPNRAccountExchange chinaPNRAccountExchange;
    /**
     * 主账号查询
     * @return
     */
    @Override
    public ResponseMessage queryAccount() {
        log.info("主账号查询...");
        Map<String,String> resMap = chinaPNRAccountExchange.queryAccount();
        log.info("主账号查询结果 resMap :{}" , resMap);
        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ACC_AMT_ERROR);
        }
        return ResultUtil.success(resMap,ResultEnum.CHINA_PNR_ACC_AMT_SUCCESS);
    }

    /**
     * 汇结回调
     * @param wholeStr
     * @return
     */
    @Override
    public ResponseMessage exchangeCallback(String wholeStr) {
        log.info("结汇回调数据 .. resXml :{}",wholeStr);
        Map<String,String> resMap = chinaPNRAccountExchange.exchangeCallback(wholeStr);
        log.info("结汇回调处理后数据 .. resMap :{}",resMap);
        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_EXCHANGE_ERROR);
        }
        //成功后组装回调信息
        String resultXml = ChinaPNRCommons.resultXml("JHHD",chinaPnrConfigure);
        return ResultUtil.success(resultXml,ResultEnum.CHINA_PNR_EXCHANGE_SUCCESS);
    }
}
