package com.js.pay.mq;

//import com.js.common.constant.RabbitMqConstant;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Author yjzhao
 * @Description 监听 mq 接收消息
 * @Date 2019/3/1 14:51
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RabbitMQReceiver {
    @RabbitListener(
            bindings = @QueueBinding(
                value = @Queue(value = "${spring.rabbitmq.queuePay}", durable = "true"),
                exchange = @Exchange(value = "${spring.rabbitmq.exchange}", type = ExchangeTypes.TOPIC),
                key = "${spring.rabbitmq.routeKeyPay}"
            )
    )
    @RabbitHandler
    public void receiveTopic2(@Payload String testId,
                              @Headers Map<String,Object> headers,
                              Channel channel) {
        log.info("com.js.pay.mq.RabbitMQReceiver.receiveTopic2 testId:{}, headers:{}, channel:{}", testId, headers, channel);
    }

}
