package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.JsPaySunrateBank;
import com.js.dal.dao.model.JsPaySunrateBankTradeIn;
import com.js.dal.dao.model.KycSunrateStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: 寻汇收款虚拟子账户表操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-3
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0,
        timeout = 30000
)
@Slf4j
public class ApiJsPaySunrateBankServiceImpl extends IBaseServiceImpl<JsPaySunrateBank> implements ApiJsPaySunrateBankService {
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    ApiJsPaySunrateBankTradeInServiceImpl apiJsPaySunrateBankTradeInServiceimpl;
    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;
    @Autowired
    ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Autowired
    ApiIMailService apiIMailService;
    @Autowired
    ApiJsKycChargeService apiJsKycChargeService;
    @Autowired
    ApiWaiHuiService apiWaiHuiService;

    @Override
    public ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq){
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("虚拟账户通知时查询店铺信息不存在");
            return ResultUtil.error(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg());
        }
        JsPaySunrateBank jsPaySunrateBank = new JsPaySunrateBank();
        BeanUtils.copyProperties(jsPaySunrateBankReq,jsPaySunrateBank);
        jsPaySunrateBank.setCusName(jsPaySunrateBankReq.getCustName());
        jsPaySunrateBank.setId(IdUtil.simpleUUID());
        jsPaySunrateBank.setKycSunrateStoreId(kycSunrateStore.getId());
        jsPaySunrateBank.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBank.setCreateName("寻汇推送");
        jsPaySunrateBank.setCreateId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBank.setJsRemark("寻汇虚拟子账户通知");
        super.insertSelective(jsPaySunrateBank);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage updateVirtualAmt(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq,JsPaySunrateBankVO jsPaySunrateBankVO) {
        JsPaySunrateBank jsPaySunrateBank = new JsPaySunrateBank();
        jsPaySunrateBank.setId(jsPaySunrateBankVO.getId());
        if(StringUtils.isBlank(jsPaySunrateBankVO.getId())){
            log.error("主键为空");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        jsPaySunrateBank.setCurrentBalance(jsPaySunrateBankVO.getCurrentBalance().add(jsPaySunrateBankTradeInReq.getTransinAmt()));
        jsPaySunrateBank.setAvailableBalance(jsPaySunrateBankVO.getAvailableBalance().add(jsPaySunrateBankTradeInReq.getTransinAmt()));
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(jsPaySunrateBank);
        log.info("更新虚拟账户余额完成，更新条数：{}",updateCount);
        JsPaySunrateBankTradeIn jsPaySunrateBankTradeInQuery = new JsPaySunrateBankTradeIn();
        jsPaySunrateBankTradeInQuery.setTransinNoticeId(jsPaySunrateBankTradeInReq.getTransinNoticeId());
        JsPaySunrateBankTradeIn jsPaySunrateBankTradeIn = apiJsPaySunrateBankTradeInServiceimpl.getiBaseMapper().selectOne(jsPaySunrateBankTradeInQuery);
        if(StringUtils.isNotBlank(jsPaySunrateBankTradeInReq.getRemark())){
            jsPaySunrateBankTradeIn.setJsRemark(jsPaySunrateBankTradeInReq.getRemark());
        }
        jsPaySunrateBankTradeIn.setCurrentBalance(jsPaySunrateBank.getCurrentBalance());
        jsPaySunrateBankTradeIn.setAvailableBalance(jsPaySunrateBank.getAvailableBalance());
        jsPaySunrateBankTradeIn.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        int updateStatus = apiJsPaySunrateBankTradeInServiceimpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySunrateBankTradeIn);
        log.info("更新入账完成，transinNoticeId{}，更新条数：{}",jsPaySunrateBankTradeInReq.getTransinNoticeId(),updateStatus);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public JsPaySunrateBankVO findSunrateBankInfo(JsPaySunrateBankReq jsPaySunrateBankReq, KycNaturalVO kycNaturalVO) {
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        if(null != kycNaturalVO){
            jsPaySunrateBankQuery.setKycNaturalId(kycNaturalVO.getId());
        }
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankReq.getSubAcctNo());
        JsPaySunrateBank jsPaySunrateBank = iBaseMapper.selectOne(jsPaySunrateBankQuery);
        if(null == jsPaySunrateBank){
            log.info("未查询到虚拟账户信息");
            return null;
        }
        JsPaySunrateBankVO jsPaySunrateBankVO = new JsPaySunrateBankVO();
        BeanUtils.copyProperties(jsPaySunrateBank,jsPaySunrateBankVO);
        return jsPaySunrateBankVO;
    }

    @Override
    public ResponseMessage selCanWithdrawAcctList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO) {
        log.info("查询可提现账户信息开始:{}",siteEnum);
        Map<String,String> params = new HashMap<>();
        params.put("kycNaturalId",kycNaturalVO.getId());
        params.put("curId",siteEnum.getCurrency());
        List<Map<String,Object>> canWithdrawStoreList = jsPaySunrateBankMapper.findCanWithdrawStoreList(params);
        canWithdrawStoreList.stream().forEach(map -> {
            map.put("withdrawAmt",map.get("currentAmt"));
            map.put("currencySymbol",SiteEnum.getByCurrency(map.get("curId").toString()).getCurrencySymbol());
        });
        log.info("查询可提现账户信息结束:条数{}", CollectionUtils.isEmpty(canWithdrawStoreList) ? 0 : canWithdrawStoreList.size());
        return ResultUtil.success(canWithdrawStoreList);
    }

    @Override
    public ResponseMessage applyWithdraw(ApplyWithdrawReq applyWithdrawReq, KycNaturalVO kycNaturalVO, KycBankVO kycBankVO) {
        log.info("店铺申请提现-开始:{}", JSON.toJSONString(applyWithdrawReq));
        try {
            KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
            kycSunrateStoreQuery.setKycStoreId(applyWithdrawReq.getStoreId());
            kycSunrateStoreQuery.setKycNaturalId(kycNaturalVO.getId());
            kycSunrateStoreQuery.setDelFlag(false);
            KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
            if (null == kycSunrateStore) {
                log.info("未查询到寻汇店铺信息:{}", JSON.toJSONString(kycSunrateStoreQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
            jsPaySunrateBankQuery.setKycNaturalId(kycNaturalVO.getId());
            jsPaySunrateBankQuery.setOrgCode(kycSunrateStore.getOrgCode());
            jsPaySunrateBankQuery.setSubAcctNo(kycSunrateStore.getSubAcctNo());
            jsPaySunrateBankQuery.setDelFlag(false);
            JsPaySunrateBank jsPaySunrateBank = jsPaySunrateBankMapper.selectOne(jsPaySunrateBankQuery);
            if (null == jsPaySunrateBank) {
                log.info("未查询到寻汇虚拟账户信息:{}", JSON.toJSONString(jsPaySunrateBankQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            if (applyWithdrawReq.getWithdrawAmt().compareTo(jsPaySunrateBank.getAvailableBalance()) > 0) {
                log.error("提现金额超出可用余额");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            BeneficiaryTypeEnum beneficiaryType = CommonConstant.TRADE_CURRENCY_CNY.equals(applyWithdrawReq.getCurrency()) ? BeneficiaryTypeEnum.PLATEFORM_SELF : BeneficiaryTypeEnum.JS_USER;
            log.info("查询提现客户受益人信息开始,受益人类型：{}",beneficiaryType);
            List<KycSunrateBeneficiaryVO> kycSunrateBeneficiaryVOS = apiSunrateBeneficiaryService.beneficiaryListByOrgCode(jsPaySunrateBank.getOrgCode(),beneficiaryType,kycBankVO.getCurrencyCode());
            if(CollectionUtils.isEmpty(kycSunrateBeneficiaryVOS)){
                log.error("查询受益人信息不存在，orgCode:{}",jsPaySunrateBank.getOrgCode());
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }

            log.info("查询提现客户受益人信息结束：{},size:{}",kycSunrateBeneficiaryVOS,kycSunrateBeneficiaryVOS.size());
            jsPaySunrateBank.setAvailableBalance(jsPaySunrateBank.getAvailableBalance().subtract(applyWithdrawReq.getWithdrawAmt()));
            jsPaySunrateBank.setFreezedBalance(jsPaySunrateBank.getFreezedBalance().add(applyWithdrawReq.getWithdrawAmt()));

            SiteEnum storeTheSite = SiteEnum.getByCurrency(jsPaySunrateBank.getCurId());
            WaiHuiVO waiHuiVO = apiWaiHuiService.getWaiHuiInfo(storeTheSite.getCurrency());
            if(null == waiHuiVO){
                log.error("查询汇率失败：{}",waiHuiVO);
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            //查询手续费
            JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
            jsKycChargeReq.setKycNaturalId(kycNaturalVO.getId());
            jsKycChargeReq.setChargeType("SERVICE_CHARGE");
            JsKycChargeVO jsKycChargeVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeReq);
            //手续费标准
            BigDecimal serviceCharge = null == jsKycChargeVO ? storeTheSite.getJsTradeServiceChargeValue() : jsKycChargeVO.getChargeScale();

            //查询客户优惠汇差
            JsKycChargeReq jsKycChargeRateReq = new JsKycChargeReq();
            jsKycChargeRateReq.setKycNaturalId(kycNaturalVO.getId());
            jsKycChargeRateReq.setChargeType("RATE");
            JsKycChargeVO jsKycChargeRateVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeRateReq);

            BigDecimal rate = null == jsKycChargeRateVO ? waiHuiVO.getHuiIn().setScale(4,BigDecimal.ROUND_HALF_UP) : jsKycChargeRateVO.getChargeScale().add(waiHuiVO.getHuiIn()).setScale(4,BigDecimal.ROUND_HALF_UP);

            JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = ConvertToJsPaySunrateTradeMarketOrderReq(applyWithdrawReq, jsPaySunrateBank, kycBankVO,kycSunrateBeneficiaryVOS.get(0));
            jsPaySunrateTradeMarketOrderReq.setUseRate(rate);
            jsPaySunrateTradeMarketOrderReq.setServiceCharge(serviceCharge);//手续费标准比例
            jsPaySunrateTradeMarketOrderReq.setStoreTheSite(kycSunrateStore.getStoreTheSite());
            waiHuiVO.setLockNo(jsPaySunrateTradeMarketOrderReq.getLockNo());
            int saveCount = apiWaiHuiService.saveWaiHuiInfo(waiHuiVO,kycNaturalVO);
            log.info("存储外汇查询信息条数：{}",saveCount);
            try {
                ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.tradeMarketOrder(jsPaySunrateTradeMarketOrderReq, kycNaturalVO.getId(), kycSunrateStore.getId(), jsPaySunrateBank.getId());
                log.info("请求寻汇市价锁汇接口返回结果：{},{}", responseMessage.isSuccess(), responseMessage.getMsg());
                if (!responseMessage.isSuccess()) {
                    log.error("调用寻汇市价锁汇失败：{}", responseMessage.getMsg());
                    apiIMailService.sendRemindEmail("调用寻汇市价锁汇失败", "调用寻汇市价锁汇失败,msg:" + responseMessage.getMsg() + ",sunrateBankCardNo: " + jsPaySunrateBank.getBankCardNo(), EmailRemindTypeEnum.WARN_EMAIL);
                    return responseMessage;
                }
            }catch (Exception ex){
                log.error("请求寻汇市价锁汇成功，但执行入库操作时失败", ex);
                apiIMailService.sendRemindEmail("调用寻汇市价锁汇失败", "请求寻汇市价锁汇成功，但执行入库操作时失败:" + JSON.toJSONString(jsPaySunrateTradeMarketOrderReq), EmailRemindTypeEnum.WARN_EMAIL);
            }
            int updateJsSunrateBankCount = jsPaySunrateBankMapper.updateByPrimaryKeySelective(jsPaySunrateBank);
            log.info("更新余额结果:{}", updateJsSunrateBankCount);
        }catch (Exception ex){
            log.error("提现交易失败storeId:{},bankId:{}",applyWithdrawReq.getStoreId(),applyWithdrawReq.getBankId());
            log.error("提现交易失败", ex);
            apiIMailService.sendRemindEmail("提现失败","提现交易失败,storeId:" + applyWithdrawReq.getStoreId() + ",batchNo:" + applyWithdrawReq.getBatchNo() + ex, EmailRemindTypeEnum.WARN_EMAIL);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage findSunrateBankInfoList(KycNaturalVO kycNaturalVO) {
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setKycNaturalId(kycNaturalVO.getId());
        List<JsPaySunrateBank> jsPaySunrateBankList = iBaseMapper.select(jsPaySunrateBankQuery);
        List<JsPaySunrateBankVO> jsPaySunrateBankVOList = new ArrayList<>();
        jsPaySunrateBankList.stream().forEach(jsPaySunrateBank -> {
            JsPaySunrateBankVO jsPaySunrateBankVO = new JsPaySunrateBankVO();
            BeanUtils.copyProperties(jsPaySunrateBank,jsPaySunrateBankVO);
            jsPaySunrateBankVOList.add(jsPaySunrateBankVO);
        });
        return ResultUtil.success(jsPaySunrateBankVOList);
    }

    private JsPaySunrateTradeMarketOrderReq ConvertToJsPaySunrateTradeMarketOrderReq(ApplyWithdrawReq applyWithdrawReq,JsPaySunrateBank jsPaySunrateBank, KycBankVO kycBankVO,KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO){
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();
        jsPaySunrateTradeMarketOrderReq.setLockNo(requestNoPrefix + ReqNoUtil.getReqNo());
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPaySunrateBank.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(jsPaySunrateBank.getSubAcctNo());
        //如果买入币种为人民币时转换币种为离岸人民币CNH，否则使用原记录币种
        jsPaySunrateTradeMarketOrderReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNY.equals(kycBankVO.getCurrencyCode()) ? CommonConstant.TRADE_CURRENCY_CNH : kycBankVO.getCurrencyCode());
        jsPaySunrateTradeMarketOrderReq.setSellCur(jsPaySunrateBank.getCurId());
        jsPaySunrateTradeMarketOrderReq.setTxnAmt(applyWithdrawReq.getWithdrawAmt());
        jsPaySunrateTradeMarketOrderReq.setValueDate(DateUtil.format(new Date(),"yyyy-MM-dd"));
        jsPaySunrateTradeMarketOrderReq.setTradeType(TradeTypeEnum.TRADE_WITHDRAW);
        jsPaySunrateTradeMarketOrderReq.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
        jsPaySunrateTradeMarketOrderReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
        jsPaySunrateTradeMarketOrderReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());//受益人编号
        jsPaySunrateTradeMarketOrderReq.setKycBankId(kycBankVO.getId());
        jsPaySunrateTradeMarketOrderReq.setBankNo(kycBankVO.getAccountNo());
        jsPaySunrateTradeMarketOrderReq.setBatchNo(applyWithdrawReq.getBatchNo());
        jsPaySunrateTradeMarketOrderReq.setSunrateBankAvailableBalance(jsPaySunrateBank.getAvailableBalance());
        jsPaySunrateTradeMarketOrderReq.setSunrateBankCurrentBalance(jsPaySunrateBank.getCurrentBalance());
        return jsPaySunrateTradeMarketOrderReq;
    }
}
